/*
 * Decompiled with CFR 0.152.
 */
package com.conaxgames.libraries.board;

import com.conaxgames.libraries.LibraryPlugin;
import com.conaxgames.libraries.board.BoardAdapter;
import com.conaxgames.libraries.board.BoardEntry;
import com.conaxgames.libraries.board.BoardTimer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Scoreboard;

public class Board {
    private final BoardAdapter adapter;
    private final Player player;
    private List<BoardEntry> entries = new ArrayList<BoardEntry>();
    private Set<BoardTimer> timers = new HashSet<BoardTimer>();
    private Set<String> keys = new HashSet<String>();
    private Scoreboard scoreboard;
    private Objective objective;

    public Board(Player player, BoardAdapter adapter) {
        this.adapter = adapter;
        this.player = player;
        this.init();
    }

    private void init() {
        this.scoreboard = !this.player.getScoreboard().equals((Object)LibraryPlugin.getInstance().getPlugin().getServer().getScoreboardManager().getMainScoreboard()) ? this.player.getScoreboard() : LibraryPlugin.getInstance().getPlugin().getServer().getScoreboardManager().getNewScoreboard();
        this.objective = this.scoreboard.registerNewObjective("Default", "dummy");
        this.objective.setDisplaySlot(DisplaySlot.SIDEBAR);
        this.objective.setDisplayName(this.adapter.getTitle(this.player));
    }

    public String getNewKey(BoardEntry entry) {
        for (ChatColor color : ChatColor.values()) {
            String colorText = color + "" + ChatColor.WHITE;
            if (entry.getText().length() > 16) {
                String sub = entry.getText().substring(0, 16);
                colorText = colorText + ChatColor.getLastColors((String)sub);
            }
            if (this.keys.contains(colorText)) continue;
            this.keys.add(colorText);
            return colorText;
        }
        throw new IndexOutOfBoundsException("No more keys available!");
    }

    public List<String> getBoardEntriesFormatted() {
        ArrayList<String> toReturn = new ArrayList<String>();
        for (BoardEntry entry : new ArrayList<BoardEntry>(this.entries)) {
            toReturn.add(entry.getText());
        }
        return toReturn;
    }

    public BoardEntry getByPosition(int position) {
        for (int i = 0; i < this.entries.size(); ++i) {
            if (i != position) continue;
            return this.entries.get(i);
        }
        return null;
    }

    public BoardTimer getCooldown(String id) {
        for (BoardTimer cooldown : this.getTimers()) {
            if (!cooldown.getId().equals(id)) continue;
            return cooldown;
        }
        return null;
    }

    public Set<BoardTimer> getTimers() {
        this.timers.removeIf(cooldown -> System.currentTimeMillis() >= cooldown.getEnd());
        return this.timers;
    }

    public BoardAdapter getAdapter() {
        return this.adapter;
    }

    public Player getPlayer() {
        return this.player;
    }

    public List<BoardEntry> getEntries() {
        return this.entries;
    }

    public Set<String> getKeys() {
        return this.keys;
    }

    public Scoreboard getScoreboard() {
        return this.scoreboard;
    }

    public Objective getObjective() {
        return this.objective;
    }
}

