/*
 * Decompiled with CFR 0.152.
 */
package com.conaxgames.libraries.acf;

import com.conaxgames.libraries.acf.ACFPatterns;
import com.conaxgames.libraries.acf.ACFUtil;
import com.conaxgames.libraries.acf.Annotations;
import com.conaxgames.libraries.acf.CommandHelp;
import com.conaxgames.libraries.acf.CommandIssuer;
import com.conaxgames.libraries.acf.CommandManager;
import com.conaxgames.libraries.acf.CommandOperationContext;
import com.conaxgames.libraries.acf.CommandRouter;
import com.conaxgames.libraries.acf.ExceptionHandler;
import com.conaxgames.libraries.acf.ForwardingCommand;
import com.conaxgames.libraries.acf.LogLevel;
import com.conaxgames.libraries.acf.MessageKeys;
import com.conaxgames.libraries.acf.MessageType;
import com.conaxgames.libraries.acf.RegisteredCommand;
import com.conaxgames.libraries.acf.RootCommand;
import com.conaxgames.libraries.acf.UnstableAPI;
import com.conaxgames.libraries.acf.annotation.CatchAll;
import com.conaxgames.libraries.acf.annotation.CatchUnknown;
import com.conaxgames.libraries.acf.annotation.CommandAlias;
import com.conaxgames.libraries.acf.annotation.CommandPermission;
import com.conaxgames.libraries.acf.annotation.Conditions;
import com.conaxgames.libraries.acf.annotation.Default;
import com.conaxgames.libraries.acf.annotation.Description;
import com.conaxgames.libraries.acf.annotation.HelpCommand;
import com.conaxgames.libraries.acf.annotation.PreCommand;
import com.conaxgames.libraries.acf.annotation.Subcommand;
import com.conaxgames.libraries.acf.annotation.UnknownHandler;
import com.conaxgames.libraries.acf.apachecommonslang.ApacheCommonsLangUtil;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Stack;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nullable;

public abstract class BaseCommand {
    static final String CATCHUNKNOWN = "__catchunknown";
    static final String DEFAULT = "__default";
    final SetMultimap<String, RegisteredCommand> subCommands = HashMultimap.create();
    final Set<BaseCommand> subScopes = new HashSet<BaseCommand>();
    final Map<Class<?>, String> contextFlags = new HashMap();
    @Nullable
    private Method preCommandHandler;
    private String execLabel;
    private String execSubcommand;
    private String[] origArgs;
    CommandManager<?, ?, ?, ?, ?, ?> manager = null;
    BaseCommand parentCommand;
    Map<String, RootCommand> registeredCommands = new HashMap<String, RootCommand>();
    @Nullable
    String description;
    @Nullable
    String commandName;
    @Nullable
    String permission;
    @Nullable
    String conditions;
    boolean hasHelpCommand;
    private ExceptionHandler exceptionHandler = null;
    private final ThreadLocal<CommandOperationContext> lastCommandOperationContext = new ThreadLocal();
    @Nullable
    private String parentSubcommand;
    private final Set<String> permissions = new HashSet<String>();

    public BaseCommand() {
    }

    @Deprecated
    public BaseCommand(@Nullable String cmd) {
        this.commandName = cmd;
    }

    public CommandOperationContext getLastCommandOperationContext() {
        return this.lastCommandOperationContext.get();
    }

    public String getExecCommandLabel() {
        return this.execLabel;
    }

    public String getExecSubcommand() {
        return this.execSubcommand;
    }

    public String[] getOrigArgs() {
        return this.origArgs;
    }

    void onRegister(CommandManager manager) {
        this.onRegister(manager, this.commandName);
    }

    private void onRegister(CommandManager manager, String cmd) {
        manager.injectDependencies(this);
        this.manager = manager;
        Annotations annotations = manager.getAnnotations();
        Class<?> self = this.getClass();
        String[] cmdAliases = annotations.getAnnotationValues(self, CommandAlias.class, 11);
        if (cmd == null && cmdAliases != null) {
            cmd = cmdAliases[0];
        }
        this.commandName = cmd != null ? cmd : self.getSimpleName().toLowerCase(Locale.ENGLISH);
        this.permission = annotations.getAnnotationValue(self, CommandPermission.class, 1);
        this.description = annotations.getAnnotationValue(self, Description.class, 9);
        this.parentSubcommand = this.getParentSubcommand(self);
        this.conditions = annotations.getAnnotationValue(self, Conditions.class, 9);
        this.computePermissions();
        this.registerSubcommands();
        this.registerSubclasses(cmd);
        if (cmdAliases != null) {
            HashSet cmdList = new HashSet();
            Collections.addAll(cmdList, cmdAliases);
            cmdList.remove(cmd);
            for (String cmdAlias : cmdList) {
                this.register(cmdAlias, this);
            }
        }
        if (cmd != null) {
            this.register(cmd, this);
        }
    }

    private void registerSubclasses(String cmd) {
        for (Class<?> clazz : this.getClass().getDeclaredClasses()) {
            if (!BaseCommand.class.isAssignableFrom(clazz)) continue;
            try {
                Constructor<?>[] declaredConstructors;
                BaseCommand subScope = null;
                for (Constructor<?> declaredConstructor : declaredConstructors = clazz.getDeclaredConstructors()) {
                    declaredConstructor.setAccessible(true);
                    Parameter[] parameters = declaredConstructor.getParameters();
                    if (parameters.length == 1) {
                        subScope = (BaseCommand)declaredConstructor.newInstance(this);
                        continue;
                    }
                    this.manager.log(LogLevel.INFO, "Found unusable constructor: " + declaredConstructor.getName() + "(" + Stream.of(parameters).map(p -> p.getType().getSimpleName() + " " + p.getName()).collect(Collectors.joining("<c2>,</c2> ")) + ")");
                }
                if (subScope != null) {
                    subScope.parentCommand = this;
                    this.subScopes.add(subScope);
                    super.onRegister(this.manager, cmd);
                    this.subCommands.putAll(subScope.subCommands);
                    this.registeredCommands.putAll(subScope.registeredCommands);
                    continue;
                }
                this.manager.log(LogLevel.ERROR, "Could not find a subcommand ctor for " + clazz.getName());
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                this.manager.log(LogLevel.ERROR, "Error registering subclass", e);
            }
        }
    }

    private void registerSubcommands() {
        Annotations annotations = this.manager.getAnnotations();
        boolean foundCatchUnknown = false;
        boolean isParentEmpty = this.parentSubcommand == null || this.parentSubcommand.isEmpty();
        LinkedHashSet methods = new LinkedHashSet();
        Collections.addAll(methods, this.getClass().getDeclaredMethods());
        Collections.addAll(methods, this.getClass().getMethods());
        for (Method method : methods) {
            boolean hasCatchUnknown;
            method.setAccessible(true);
            String sublist = null;
            String sub = this.getSubcommandValue(method);
            String helpCommand = annotations.getAnnotationValue(method, HelpCommand.class, 0);
            String commandAliases = annotations.getAnnotationValue(method, CommandAlias.class, 0);
            if (annotations.hasAnnotation(method, Default.class)) {
                if (!isParentEmpty) {
                    sub = this.parentSubcommand;
                } else {
                    this.registerSubcommand(method, DEFAULT);
                }
            }
            if (sub != null) {
                sublist = sub;
            } else if (commandAliases != null) {
                sublist = commandAliases;
            } else if (helpCommand != null) {
                sublist = helpCommand;
                this.hasHelpCommand = true;
            }
            boolean preCommand = annotations.hasAnnotation(method, PreCommand.class);
            boolean bl = hasCatchUnknown = annotations.hasAnnotation(method, CatchUnknown.class) || annotations.hasAnnotation(method, CatchAll.class) || annotations.hasAnnotation(method, UnknownHandler.class);
            if (hasCatchUnknown || !foundCatchUnknown && helpCommand != null) {
                if (!foundCatchUnknown) {
                    if (hasCatchUnknown) {
                        this.subCommands.get((Object)CATCHUNKNOWN).clear();
                        foundCatchUnknown = true;
                    }
                    this.registerSubcommand(method, CATCHUNKNOWN);
                } else {
                    ACFUtil.sneaky(new IllegalStateException("Multiple @CatchUnknown/@HelpCommand commands, duplicate on " + method.getDeclaringClass().getName() + "#" + method.getName()));
                }
            } else if (preCommand) {
                if (this.preCommandHandler == null) {
                    this.preCommandHandler = method;
                } else {
                    ACFUtil.sneaky(new IllegalStateException("Multiple @PreCommand commands, duplicate on " + method.getDeclaringClass().getName() + "#" + method.getName()));
                }
            }
            if (!Objects.equals(method.getDeclaringClass(), this.getClass()) || sublist == null) continue;
            this.registerSubcommand(method, sublist);
        }
    }

    private void computePermissions() {
        this.permissions.clear();
        if (this.permission != null && !this.permission.isEmpty()) {
            this.permissions.addAll(Arrays.asList(ACFPatterns.COMMA.split(this.permission)));
        }
        if (this.parentCommand != null) {
            this.permissions.addAll(this.parentCommand.getRequiredPermissions());
        }
        this.subCommands.values().forEach(RegisteredCommand::computePermissions);
        this.subScopes.forEach(BaseCommand::computePermissions);
    }

    private String getSubcommandValue(Method method) {
        String sub = this.manager.getAnnotations().getAnnotationValue(method, Subcommand.class, 0);
        if (sub == null) {
            return null;
        }
        Class<?> clazz = method.getDeclaringClass();
        String parent = this.getParentSubcommand(clazz);
        return parent == null || parent.isEmpty() ? sub : parent + " " + sub;
    }

    private String getParentSubcommand(Class<?> clazz) {
        ArrayList<String> subList = new ArrayList<String>();
        while (clazz != null) {
            String sub = this.manager.getAnnotations().getAnnotationValue(clazz, Subcommand.class, 0);
            if (sub != null) {
                subList.add(sub);
            }
            clazz = clazz.getEnclosingClass();
        }
        Collections.reverse(subList);
        return ACFUtil.join(subList, " ");
    }

    private void register(String name, BaseCommand cmd) {
        String nameLower = name.toLowerCase(Locale.ENGLISH);
        RootCommand rootCommand = this.manager.obtainRootCommand(nameLower);
        rootCommand.addChild(cmd);
        this.registeredCommands.put(nameLower, rootCommand);
    }

    private void registerSubcommand(Method method, String subCommand) {
        subCommand = this.manager.getCommandReplacements().replace(subCommand.toLowerCase(Locale.ENGLISH));
        Object[] subCommandParts = ACFPatterns.SPACE.split(subCommand);
        Set<String> cmdList = BaseCommand.getSubCommandPossibilityList((String[])subCommandParts);
        for (int i = 0; i < subCommandParts.length; ++i) {
            String[] split = ACFPatterns.PIPE.split((CharSequence)subCommandParts[i]);
            if (split.length == 0 || split[0].isEmpty()) {
                throw new IllegalArgumentException("Invalid @Subcommand configuration for " + method.getName() + " - parts can not start with | or be empty");
            }
            subCommandParts[i] = split[0];
        }
        String prefSubCommand = ApacheCommonsLangUtil.join(subCommandParts, " ");
        String[] aliasNames = this.manager.getAnnotations().getAnnotationValues((AnnotatedElement)method, CommandAlias.class, 3);
        String cmdName = aliasNames != null ? aliasNames[0] : this.commandName + " ";
        RegisteredCommand cmd = this.manager.createRegisteredCommand(this, cmdName, method, prefSubCommand);
        for (String subcmd : cmdList) {
            this.subCommands.put((Object)subcmd, (Object)cmd);
        }
        cmd.addSubcommands(cmdList);
        if (aliasNames != null) {
            for (String name : aliasNames) {
                this.register(name, new ForwardingCommand(this, cmd, (String[])subCommandParts));
            }
        }
    }

    private static Set<String> getSubCommandPossibilityList(String[] subCommandParts) {
        HashSet<String> newList;
        int i = 0;
        HashSet<String> current = null;
        while (true) {
            newList = new HashSet<String>();
            if (i < subCommandParts.length) {
                for (String s1 : ACFPatterns.PIPE.split(subCommandParts[i])) {
                    if (current != null) {
                        newList.addAll(current.stream().map(s -> s + " " + s1).collect(Collectors.toList()));
                        continue;
                    }
                    newList.add(s1);
                }
            }
            if (i + 1 >= subCommandParts.length) break;
            current = newList;
            ++i;
        }
        return newList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void execute(CommandIssuer issuer, CommandRouter.CommandRouteResult command) {
        try {
            CommandOperationContext commandContext = this.preCommandOperation(issuer, command.commandLabel, command.args, false);
            this.execSubcommand = command.subcommand;
            this.executeCommand(commandContext, issuer, command.args, command.cmd);
        }
        finally {
            this.postCommandOperation();
        }
    }

    private void postCommandOperation() {
        CommandManager.commandOperationContext.get().pop();
        this.lastCommandOperationContext.set(null);
        this.execSubcommand = null;
        this.execLabel = null;
        this.origArgs = new String[0];
    }

    private CommandOperationContext preCommandOperation(CommandIssuer issuer, String commandLabel, String[] args, boolean isAsync) {
        Stack<CommandOperationContext> contexts = CommandManager.commandOperationContext.get();
        CommandOperationContext<?> context = this.manager.createCommandOperationContext(this, issuer, commandLabel, args, isAsync);
        contexts.push(context);
        this.lastCommandOperationContext.set(context);
        this.execSubcommand = null;
        this.execLabel = commandLabel;
        this.origArgs = args;
        return context;
    }

    public CommandIssuer getCurrentCommandIssuer() {
        return CommandManager.getCurrentCommandIssuer();
    }

    public CommandManager getCurrentCommandManager() {
        return CommandManager.getCurrentCommandManager();
    }

    private void executeCommand(CommandOperationContext commandOperationContext, CommandIssuer issuer, String[] args, RegisteredCommand cmd) {
        if (cmd.hasPermission(issuer)) {
            commandOperationContext.setRegisteredCommand(cmd);
            if (this.checkPrecommand(commandOperationContext, cmd, issuer, args)) {
                return;
            }
            List<String> sargs = Arrays.asList(args);
            cmd.invoke(issuer, sargs, commandOperationContext);
        } else {
            issuer.sendMessage(MessageType.ERROR, MessageKeys.PERMISSION_DENIED, new String[0]);
        }
    }

    @Deprecated
    public boolean canExecute(CommandIssuer issuer, RegisteredCommand<?> cmd) {
        return true;
    }

    public List<String> tabComplete(CommandIssuer issuer, String commandLabel, String[] args) {
        return this.tabComplete(issuer, commandLabel, args, false);
    }

    public List<String> tabComplete(CommandIssuer issuer, String commandLabel, String[] args, boolean isAsync) throws IllegalArgumentException {
        return this.tabComplete(issuer, this.manager.getRootCommand(commandLabel.toLowerCase(Locale.ENGLISH)), args, isAsync);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<String> tabComplete(CommandIssuer issuer, RootCommand rootCommand, String[] args, boolean isAsync) throws IllegalArgumentException {
        if (args.length == 0) {
            args = new String[]{""};
        }
        String commandLabel = rootCommand.getCommandName();
        try {
            CommandRouter router = this.manager.getRouter();
            this.preCommandOperation(issuer, commandLabel, args, isAsync);
            CommandRouter.RouteSearch search = router.routeCommand(rootCommand, commandLabel, args, true);
            ArrayList<String> cmds = new ArrayList<String>();
            if (search != null) {
                for (RegisteredCommand command : search.commands) {
                    cmds.addAll(this.completeCommand(issuer, command, search.args, commandLabel, isAsync));
                }
            }
            List<String> list = BaseCommand.filterTabComplete(args[args.length - 1], cmds);
            return list;
        }
        finally {
            this.postCommandOperation();
        }
    }

    List<String> getCommandsForCompletion(CommandIssuer issuer, String[] args) {
        HashSet<String> cmds = new HashSet<String>();
        int cmdIndex = Math.max(0, args.length - 1);
        String argString = ApacheCommonsLangUtil.join((Object[])args, " ").toLowerCase(Locale.ENGLISH);
        for (Map.Entry entry : this.subCommands.entries()) {
            RegisteredCommand value;
            String key = (String)entry.getKey();
            if (!key.startsWith(argString) || BaseCommand.isSpecialSubcommand(key) || !(value = (RegisteredCommand)entry.getValue()).hasPermission(issuer) || value.isPrivate) continue;
            String[] split = ACFPatterns.SPACE.split(value.prefSubCommand);
            cmds.add(split[cmdIndex]);
        }
        return new ArrayList<String>(cmds);
    }

    static boolean isSpecialSubcommand(String key) {
        return CATCHUNKNOWN.equals(key) || DEFAULT.equals(key);
    }

    private List<String> completeCommand(CommandIssuer issuer, RegisteredCommand cmd, String[] args, String commandLabel, boolean isAsync) {
        if (!cmd.hasPermission(issuer) || args.length == 0 || cmd.parameters.length == 0) {
            return Collections.emptyList();
        }
        if (!cmd.parameters[cmd.parameters.length - 1].consumesRest && args.length > cmd.consumeInputResolvers) {
            return Collections.emptyList();
        }
        List<String> cmds = this.manager.getCommandCompletions().of(cmd, issuer, args, isAsync);
        return BaseCommand.filterTabComplete(args[args.length - 1], cmds);
    }

    private static List<String> filterTabComplete(String arg, List<String> cmds) {
        return cmds.stream().distinct().filter(cmd -> cmd != null && (arg.isEmpty() || ApacheCommonsLangUtil.startsWithIgnoreCase(cmd, arg))).collect(Collectors.toList());
    }

    private boolean checkPrecommand(CommandOperationContext commandOperationContext, RegisteredCommand cmd, CommandIssuer issuer, String[] args) {
        Method pre = this.preCommandHandler;
        if (pre != null) {
            try {
                Class<?>[] types = pre.getParameterTypes();
                Object[] parameters = new Object[pre.getParameterCount()];
                for (int i = 0; i < parameters.length; ++i) {
                    Class<?> type = types[i];
                    Object issuerObject = issuer.getIssuer();
                    parameters[i] = this.manager.isCommandIssuer(type) && type.isAssignableFrom(issuerObject.getClass()) ? issuerObject : (CommandIssuer.class.isAssignableFrom(type) ? issuer : (RegisteredCommand.class.isAssignableFrom(type) ? cmd : (String[].class.isAssignableFrom(type) ? args : null)));
                }
                return (Boolean)pre.invoke((Object)this, parameters);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                this.manager.log(LogLevel.ERROR, "Exception encountered while command pre-processing", e);
            }
        }
        return false;
    }

    @Deprecated
    @UnstableAPI
    public CommandHelp getCommandHelp() {
        return this.manager.generateCommandHelp();
    }

    @Deprecated
    @UnstableAPI
    public void showCommandHelp() {
        this.getCommandHelp().showHelp();
    }

    public void help(Object issuer, String[] args) {
        this.help((CommandIssuer)this.manager.getCommandIssuer(issuer), args);
    }

    public void help(CommandIssuer issuer, String[] args) {
        issuer.sendMessage(MessageType.ERROR, MessageKeys.UNKNOWN_COMMAND, new String[0]);
    }

    public void doHelp(Object issuer, String ... args) {
        this.doHelp((CommandIssuer)this.manager.getCommandIssuer(issuer), args);
    }

    public void doHelp(CommandIssuer issuer, String ... args) {
        this.help(issuer, args);
    }

    public void showSyntax(CommandIssuer issuer, RegisteredCommand<?> cmd) {
        issuer.sendMessage(MessageType.SYNTAX, MessageKeys.INVALID_SYNTAX, "{command}", this.manager.getCommandPrefix(issuer) + cmd.command, "{syntax}", cmd.getSyntaxText(issuer));
    }

    public boolean hasPermission(Object issuer) {
        return this.hasPermission((CommandIssuer)this.manager.getCommandIssuer(issuer));
    }

    public boolean hasPermission(CommandIssuer issuer) {
        return this.manager.hasPermission(issuer, this.getRequiredPermissions());
    }

    public Set<String> getRequiredPermissions() {
        return this.permissions;
    }

    public boolean requiresPermission(String permission) {
        return this.getRequiredPermissions().contains(permission);
    }

    public String getName() {
        return this.commandName;
    }

    public ExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    public BaseCommand setExceptionHandler(ExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
        return this;
    }

    public RegisteredCommand getDefaultRegisteredCommand() {
        return (RegisteredCommand)ACFUtil.getFirstElement(this.subCommands.get((Object)DEFAULT));
    }

    public String setContextFlags(Class<?> cls, String flags) {
        return this.contextFlags.put(cls, flags);
    }

    public String getContextFlags(Class<?> cls) {
        return this.contextFlags.get(cls);
    }

    public List<RegisteredCommand> getRegisteredCommands() {
        ArrayList<RegisteredCommand> registeredCommands = new ArrayList<RegisteredCommand>();
        registeredCommands.addAll(this.subCommands.values());
        return registeredCommands;
    }

    protected SetMultimap<String, RegisteredCommand> getSubCommands() {
        return this.subCommands;
    }
}

