/*
 * Decompiled with CFR 0.152.
 */
package com.conaxgames.libraries;

import com.conaxgames.libraries.LibraryPlugin;
import com.conaxgames.libraries.commands.message.ACFCoreMessage;
import com.conaxgames.libraries.config.CommentedConfiguration;
import java.io.File;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.bukkit.Bukkit;

public class Settings {
    public boolean debug;
    public Map<ACFCoreMessage, String> acfMessages = new HashMap<ACFCoreMessage, String>();

    public Settings() {
        this.reload();
    }

    public void reload() {
        File file = new File(LibraryPlugin.getInstance().getPlugin().getDataFolder(), "settings.yml");
        if (!file.exists()) {
            LibraryPlugin.getInstance().getPlugin().saveResource("settings.yml", false);
        }
        CommentedConfiguration settings = CommentedConfiguration.loadConfiguration(file);
        try {
            settings.syncWithConfig(file, LibraryPlugin.getInstance().getPlugin().getResource("settings.yml"), new String[0]);
        }
        catch (Exception exception) {
            Bukkit.getLogger().info("Unable to load settings.yml");
        }
        this.debug = settings.getBoolean("serverdata.debug");
        for (ACFCoreMessage enumeration : ACFCoreMessage.values()) {
            String path = enumeration.name().replace("__", ".");
            path = path.replace("_", "-");
            path = path.toLowerCase(Locale.ROOT);
            path = "commands." + path;
            if (settings.contains(path)) {
                this.acfMessages.put(enumeration, String.valueOf(settings.get(path)));
                continue;
            }
            this.acfMessages.put(enumeration, enumeration.getMessage());
        }
    }
}

