/*
 * Decompiled with CFR 0.152.
 */
package com.conaxgames.libraries;

import com.conaxgames.libraries.Settings;
import com.conaxgames.libraries.acf.PaperCommandManager;
import com.conaxgames.libraries.board.BoardManager;
import com.conaxgames.libraries.commands.CommandRegistry;
import com.conaxgames.libraries.debug.LibraryLogger;
import com.conaxgames.libraries.event.impl.LibraryPluginEnableEvent;
import com.conaxgames.libraries.hooks.HookManager;
import com.conaxgames.libraries.listener.PlayerListener;
import com.conaxgames.libraries.module.ModuleManager;
import com.conaxgames.libraries.timer.TimerManager;
import com.google.common.base.Joiner;
import java.util.Arrays;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.plugin.IllegalPluginAccessException;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class LibraryPlugin {
    private static LibraryPlugin instance;
    private boolean setup;
    private JavaPlugin plugin;
    private LibraryLogger libraryLogger;
    private TimerManager timerManager;
    private PaperCommandManager paperCommandManager;
    private CommandRegistry commandRegistry;
    private BoardManager boardManager;
    private HookManager hookManager;
    private ModuleManager moduleManager;
    private Settings settings = null;

    public static LibraryPlugin getInstance() {
        if (instance == null) {
            throw new IllegalPluginAccessException("cLibraries is not registered.");
        }
        return instance;
    }

    public LibraryPlugin onEnable(JavaPlugin plugin, String debugPrimary, String debugSecondary, String moduleCommandAlias, String moduleCommandPerm) {
        if (this.setup) {
            String authors = Joiner.on((String)", ").join((Iterable)this.plugin.getDescription().getAuthors());
            this.libraryLogger.toConsole("cLibraries", Arrays.asList(" ", "cLibraries is already setup!", this.plugin.getName() + " has called onEnable twice!", "Please nag " + authors + " to fix this!", " "), new Throwable[0]);
            return this;
        }
        instance = this;
        this.plugin = plugin;
        try {
            this.settings = new Settings();
        }
        catch (Exception e) {
            Bukkit.getLogger().info(" ");
            Bukkit.getLogger().info("cLibraries settings were unable to load!");
            Bukkit.getLogger().info(" ");
        }
        this.libraryLogger = new LibraryLogger(plugin, debugPrimary, debugSecondary);
        this.paperCommandManager = new PaperCommandManager((Plugin)this.plugin);
        this.commandRegistry = new CommandRegistry(this, this.paperCommandManager);
        this.hookManager = new HookManager(this);
        this.timerManager = new TimerManager();
        this.moduleManager = new ModuleManager(this, moduleCommandAlias, moduleCommandPerm);
        Arrays.asList(new PlayerListener(this), this.hookManager).forEach(l -> Bukkit.getPluginManager().registerEvents(l, (Plugin)this.plugin));
        new LibraryPluginEnableEvent().call();
        this.setup = true;
        String authors = Joiner.on((String)", ").join((Iterable)this.plugin.getDescription().getAuthors());
        this.libraryLogger.toConsole("cLibraries", Arrays.asList(" ", "cLibraries instance has been setup for " + this.plugin.getName() + " (" + authors + ")", " "), new Throwable[0]);
        return this;
    }

    public LibraryPlugin onDisable() {
        this.moduleManager.disableAllModules();
        return this;
    }

    public Settings getSettings() {
        return this.settings;
    }

    public JavaPlugin getPlugin() {
        return this.plugin;
    }

    public void setBoardManager(BoardManager boardManager) {
        this.boardManager = boardManager;
        long interval = this.boardManager.getAdapter().getInterval();
        this.plugin.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)this.plugin, (Runnable)this.boardManager, 0L, interval);
    }

    @Generated
    public boolean isSetup() {
        return this.setup;
    }

    @Generated
    public LibraryLogger getLibraryLogger() {
        return this.libraryLogger;
    }

    @Generated
    public TimerManager getTimerManager() {
        return this.timerManager;
    }

    @Generated
    public PaperCommandManager getPaperCommandManager() {
        return this.paperCommandManager;
    }

    @Generated
    public CommandRegistry getCommandRegistry() {
        return this.commandRegistry;
    }

    @Generated
    public BoardManager getBoardManager() {
        return this.boardManager;
    }

    @Generated
    public HookManager getHookManager() {
        return this.hookManager;
    }

    @Generated
    public ModuleManager getModuleManager() {
        return this.moduleManager;
    }

    @Generated
    public void setSetup(boolean setup) {
        this.setup = setup;
    }

    @Generated
    public void setPlugin(JavaPlugin plugin) {
        this.plugin = plugin;
    }

    @Generated
    public void setLibraryLogger(LibraryLogger libraryLogger) {
        this.libraryLogger = libraryLogger;
    }

    @Generated
    public void setTimerManager(TimerManager timerManager) {
        this.timerManager = timerManager;
    }

    @Generated
    public void setPaperCommandManager(PaperCommandManager paperCommandManager) {
        this.paperCommandManager = paperCommandManager;
    }

    @Generated
    public void setCommandRegistry(CommandRegistry commandRegistry) {
        this.commandRegistry = commandRegistry;
    }

    @Generated
    public void setHookManager(HookManager hookManager) {
        this.hookManager = hookManager;
    }

    @Generated
    public void setModuleManager(ModuleManager moduleManager) {
        this.moduleManager = moduleManager;
    }

    @Generated
    public void setSettings(Settings settings) {
        this.settings = settings;
    }

    @Generated
    public static void setInstance(LibraryPlugin instance) {
        LibraryPlugin.instance = instance;
    }
}

