/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.core.utils.ray;

import me.deecaad.core.compatibility.HitBox;
import me.deecaad.core.utils.MinecraftVersions;
import me.deecaad.core.utils.ray.BlockTraceResult;
import me.deecaad.core.utils.ray.EntityTraceResult;
import org.bukkit.Color;
import org.bukkit.Particle;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RayTraceResult {
    private static final Particle DUST_PARTICLE = MinecraftVersions.TRAILS_AND_TAILS.get(5).isAtLeast() ? Particle.DUST : Particle.valueOf((String)"REDSTONE");
    @NotNull
    private final Vector origin;
    @NotNull
    private final Vector direction;
    @NotNull
    private final HitBox hitBox;
    @NotNull
    private final BlockFace hitFace;
    @NotNull
    private final BlockFace exitFace;
    private final double hitMin;
    private final double hitMax;
    @Nullable
    private Vector hitLocation;
    @Nullable
    private Vector exitLocation;

    public RayTraceResult(@NotNull Vector origin, @NotNull Vector direction, @NotNull HitBox hitBox, @NotNull BlockFace hitFace, @NotNull BlockFace exitFace, double hitMin, double hitMax) {
        this.origin = origin;
        this.direction = direction;
        this.hitBox = hitBox;
        this.hitFace = hitFace;
        this.exitFace = exitFace;
        this.hitMin = hitMin;
        this.hitMax = hitMax;
    }

    @NotNull
    public HitBox getHitBox() {
        return this.hitBox;
    }

    @NotNull
    public BlockFace getHitFace() {
        return this.hitFace;
    }

    @NotNull
    public BlockFace getExitFace() {
        return this.exitFace;
    }

    @NotNull
    public Vector getHitLocation() {
        if (this.hitLocation == null) {
            this.hitLocation = this.origin.clone();
            this.hitLocation.setX(this.hitLocation.getX() + this.direction.getX() * this.hitMin);
            this.hitLocation.setY(this.hitLocation.getY() + this.direction.getY() * this.hitMin);
            this.hitLocation.setZ(this.hitLocation.getZ() + this.direction.getZ() * this.hitMin);
        }
        return this.hitLocation;
    }

    @NotNull
    public Vector getExitLocation() {
        if (this.exitLocation == null) {
            this.exitLocation = this.origin.clone();
            this.exitLocation.setX(this.exitLocation.getX() + this.direction.getX() * this.hitMax);
            this.exitLocation.setY(this.exitLocation.getY() + this.direction.getY() * this.hitMax);
            this.exitLocation.setZ(this.exitLocation.getZ() + this.direction.getZ() * this.hitMax);
        }
        return this.exitLocation;
    }

    public double getHitMin() {
        return this.hitMin;
    }

    public double getHitMinClamped() {
        return Math.max(this.hitMin, 0.0);
    }

    public double getHitMax() {
        return this.hitMax;
    }

    public double getThroughDistance() {
        return Math.max(this.hitMax - this.hitMin, 0.0);
    }

    public void outlineOnlyHitPosition(Entity player) {
        Vector hitLocation = this.getHitLocation();
        double x = hitLocation.getX();
        double y = hitLocation.getY();
        double z = hitLocation.getZ();
        if (!MinecraftVersions.UPDATE_AQUATIC.isAtLeast()) {
            player.getWorld().spawnParticle(Particle.CRIT, x, y, z, 1, 0.0, 0.0, 0.0, 1.0E-4);
        } else {
            player.getWorld().spawnParticle(DUST_PARTICLE, x, y, z, 1, 0.0, 0.0, 0.0, 1.0E-4, (Object)new Particle.DustOptions(Color.BLACK, 1.5f), true);
        }
    }

    @Deprecated
    public boolean isBlock() {
        return this instanceof BlockTraceResult;
    }

    @Deprecated
    public Block getBlock() {
        return ((BlockTraceResult)this).getBlock();
    }

    @Deprecated
    public boolean isEntity() {
        return this instanceof EntityTraceResult;
    }

    @Deprecated
    public Entity getLivingEntity() {
        return ((EntityTraceResult)this).getEntity();
    }

    public String toString() {
        return "RayTraceResult{hitFace=" + String.valueOf(this.hitFace) + ", hitLocation=" + String.valueOf(this.hitLocation) + ", hitMin=" + this.hitMin + ", hitMax=" + this.hitMax + "}";
    }
}

