/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.core.utils.ray;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import me.deecaad.core.compatibility.CompatibilityAPI;
import me.deecaad.core.compatibility.HitBox;
import me.deecaad.core.utils.NumberUtil;
import me.deecaad.core.utils.ray.BlockTraceResult;
import me.deecaad.core.utils.ray.EntityTraceResult;
import me.deecaad.core.utils.ray.RayTraceResult;
import org.bukkit.Chunk;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.util.Vector;

public class RayTrace {
    private boolean disableEntityChecks;
    private boolean disableBlockChecks;
    private Predicate<LivingEntity> entityFilter;
    private Predicate<Block> blockFilter;
    private Entity entity;
    private boolean outlineHitPosition;
    private boolean outlineHitBox;
    private boolean allowLiquid;
    private double raySize = 0.1;

    public RayTrace disableEntityChecks() {
        this.disableEntityChecks = true;
        return this;
    }

    public RayTrace disableBlockChecks() {
        this.disableBlockChecks = true;
        return this;
    }

    public RayTrace withEntityFilter(Predicate<LivingEntity> entityFilter) {
        this.entityFilter = entityFilter;
        return this;
    }

    public RayTrace withBlockFilter(Predicate<Block> blockFilter) {
        this.blockFilter = blockFilter;
        return this;
    }

    public RayTrace withOutlineHitPosition(Entity entity) {
        this.outlineHitPosition = true;
        this.entity = entity;
        return this;
    }

    public RayTrace withOutlineHitBox(Entity entity) {
        this.outlineHitBox = true;
        this.entity = entity;
        return this;
    }

    public RayTrace enableLiquidChecks() {
        this.allowLiquid = true;
        return this;
    }

    public RayTrace withRaySize(double size) {
        this.raySize = size;
        return this;
    }

    public List<RayTraceResult> cast(World world, Vector start, Vector direction, double range) {
        return this.cast(world, start, start.clone().add(direction.clone().multiply(range)), direction);
    }

    public List<RayTraceResult> cast(World world, Vector start, Vector end) {
        return this.cast(world, start, end, end.clone().subtract(start).normalize());
    }

    public List<RayTraceResult> cast(World world, Vector start, Vector end, Vector direction) {
        return this.cast(world, start, end, direction, 0.0);
    }

    public List<RayTraceResult> cast(World world, Vector start, Vector end, Vector direction, double maximumBlockThrough) {
        ArrayList<RayTraceResult> hits = new ArrayList<RayTraceResult>(5);
        this.getBlockHits(hits, world, start, end, direction, maximumBlockThrough);
        this.getEntityHits(hits, world, start, end, direction);
        if (!hits.isEmpty()) {
            if (hits.size() > 1) {
                hits.sort(Comparator.comparingDouble(RayTraceResult::getHitMin));
            }
            if (this.outlineHitPosition) {
                ((RayTraceResult)hits.get(0)).outlineOnlyHitPosition(this.entity);
            }
            if (this.outlineHitBox) {
                RayTraceResult firstHit = (RayTraceResult)hits.get(0);
                if (firstHit instanceof BlockTraceResult) {
                    BlockTraceResult blockHit = (BlockTraceResult)firstHit;
                    CompatibilityAPI.getBlockCompatibility().getHitBox(blockHit.getBlock()).outlineAllBoxes(this.entity);
                } else if (firstHit instanceof EntityTraceResult) {
                    EntityTraceResult entityHit = (EntityTraceResult)firstHit;
                    HitBox entityBox = CompatibilityAPI.getEntityCompatibility().getHitBox((Entity)entityHit.getEntity());
                    entityBox.grow(this.raySize);
                    entityBox.outlineAllBoxes(this.entity);
                }
            }
            return hits;
        }
        return null;
    }

    private void getBlockHits(List<RayTraceResult> hits, World world, Vector start, Vector end, Vector direction, double maximumBlockThrough) {
        int currentZ;
        int currentY;
        if (this.disableBlockChecks) {
            return;
        }
        double startX = NumberUtil.lerp(start.getX(), end.getX(), -1.0E-7);
        double startY = NumberUtil.lerp(start.getY(), end.getY(), -1.0E-7);
        double startZ = NumberUtil.lerp(start.getZ(), end.getZ(), -1.0E-7);
        int currentX = NumberUtil.floorToInt(startX);
        Block startBlock = world.getBlockAt(currentX, currentY = NumberUtil.floorToInt(startY), currentZ = NumberUtil.floorToInt(startZ));
        RayTraceResult rayStartBlock = this.rayBlock(startBlock, start, direction);
        if (rayStartBlock != null) {
            hits.add(rayStartBlock);
            if (!(this.allowLiquid && startBlock.isLiquid() || maximumBlockThrough == -1.0)) {
                double d;
                maximumBlockThrough -= rayStartBlock.getThroughDistance();
                if (d < 0.0) {
                    return;
                }
            }
        }
        double endX = NumberUtil.lerp(end.getX(), start.getX(), -1.0E-7);
        double endY = NumberUtil.lerp(end.getY(), start.getY(), -1.0E-7);
        double endZ = NumberUtil.lerp(end.getZ(), start.getZ(), -1.0E-7);
        double directionX = endX - startX;
        double directionY = endY - startY;
        double directionZ = endZ - startZ;
        int blockX = NumberUtil.signum(directionX);
        int blockY = NumberUtil.signum(directionY);
        int blockZ = NumberUtil.signum(directionZ);
        double addX = blockX == 0 ? Double.MAX_VALUE : (double)blockX / directionX;
        double addY = blockY == 0 ? Double.MAX_VALUE : (double)blockY / directionY;
        double addZ = blockZ == 0 ? Double.MAX_VALUE : (double)blockZ / directionZ;
        double maxX = addX * (blockX > 0 ? 1.0 - NumberUtil.fraction(startX) : NumberUtil.fraction(startX));
        double maxY = addY * (blockY > 0 ? 1.0 - NumberUtil.fraction(startY) : NumberUtil.fraction(startY));
        double maxZ = addZ * (blockZ > 0 ? 1.0 - NumberUtil.fraction(startZ) : NumberUtil.fraction(startZ));
        while (!(!(maximumBlockThrough > -1.0) || maxX > 1.0 && maxY > 1.0 && maxZ > 1.0)) {
            double d;
            Block newBlock;
            RayTraceResult rayNewBlock;
            if (maxX < maxY) {
                if (maxX < maxZ) {
                    currentX += blockX;
                    maxX += addX;
                } else {
                    currentZ += blockZ;
                    maxZ += addZ;
                }
            } else if (maxY < maxZ) {
                currentY += blockY;
                maxY += addY;
            } else {
                currentZ += blockZ;
                maxZ += addZ;
            }
            if ((rayNewBlock = this.rayBlock(newBlock = world.getBlockAt(currentX, currentY, currentZ), start, direction)) == null) continue;
            hits.add(rayNewBlock);
            if (this.allowLiquid && newBlock.isLiquid()) continue;
            maximumBlockThrough -= 1.0;
            if (!(d < 0.0)) continue;
            break;
        }
    }

    private RayTraceResult rayBlock(Block block, Vector start, Vector direction) {
        if (this.blockFilter != null && this.blockFilter.test(block)) {
            return null;
        }
        HitBox blockBox = CompatibilityAPI.getBlockCompatibility().getHitBox(block, this.allowLiquid);
        if (blockBox == null) {
            return null;
        }
        return blockBox.rayTrace(start, direction);
    }

    private void getEntityHits(List<RayTraceResult> hits, World world, Vector start, Vector end, Vector direction) {
        if (this.disableEntityChecks) {
            return;
        }
        HitBox hitBox = new HitBox(start, end);
        int minX = NumberUtil.floorToInt((hitBox.getMinX() - 2.0) / 16.0);
        int maxX = NumberUtil.floorToInt((hitBox.getMaxX() + 2.0) / 16.0);
        int minZ = NumberUtil.floorToInt((hitBox.getMinZ() - 2.0) / 16.0);
        int maxZ = NumberUtil.floorToInt((hitBox.getMaxZ() + 2.0) / 16.0);
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                Chunk chunk = world.getChunkAt(x, z);
                for (Entity entity : chunk.getEntities()) {
                    RayTraceResult rayNewEntity = this.rayEntity(hitBox, entity, start, direction);
                    if (rayNewEntity == null) continue;
                    hits.add(rayNewEntity);
                }
            }
        }
    }

    private RayTraceResult rayEntity(HitBox hitBox, Entity entity, Vector start, Vector direction) {
        if (!entity.getType().isAlive()) {
            return null;
        }
        if (this.entityFilter != null && this.entityFilter.test((LivingEntity)entity)) {
            return null;
        }
        HitBox entityBox = CompatibilityAPI.getEntityCompatibility().getHitBox(entity);
        if (entityBox == null) {
            return null;
        }
        entityBox.grow(this.raySize);
        if (!hitBox.overlaps(entityBox)) {
            return null;
        }
        return entityBox.rayTrace(start, direction);
    }
}

