/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.core.utils;

import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import me.deecaad.core.utils.ImmutableVector;
import me.deecaad.core.utils.NumberExtensionsKt;
import me.deecaad.core.utils.NumberUtil;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\t\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0018H\u0007J\u0018\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u0018H\u0007J\u0018\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u0018H\u0007J\u0018\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u001f\u001a\u00020\u0014H\u0007J$\u0010 \u001a\u00020\u00142\u0006\u0010!\u001a\u00020\u00142\b\b\u0002\u0010\"\u001a\u00020\u00142\b\b\u0002\u0010#\u001a\u00020\u0014H\u0007J\u001a\u0010$\u001a\u00020%2\u0006\u0010\u001e\u001a\u00020\u00142\b\b\u0002\u0010&\u001a\u00020\u0018H\u0007J \u0010'\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u001f\u001a\u00020\u00142\u0006\u0010(\u001a\u00020\u0018H\u0007J \u0010)\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u001f\u001a\u00020\u00142\u0006\u0010(\u001a\u00020\u0018H\u0007J\u0018\u0010*\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u001f\u001a\u00020\u0014H\u0007J\u0018\u0010+\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u001f\u001a\u00020\u0014H\u0007J\u0018\u0010,\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010-\u001a\u00020\u0018H\u0007R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0011\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u0011\u0010\r\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006R\u0011\u0010\u000f\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0006R\u0011\u0010\u0011\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0006\u00a8\u0006."}, d2={"Lme/deecaad/core/utils/VectorUtil;", "", "()V", "DOWN", "Lme/deecaad/core/utils/ImmutableVector;", "getDOWN", "()Lme/deecaad/core/utils/ImmutableVector;", "EAST", "getEAST", "NORTH", "getNORTH", "SOUTH", "getSOUTH", "UP", "getUP", "WEST", "getWEST", "ZERO", "getZERO", "addScaledVector", "Lorg/bukkit/util/Vector;", "vector", "other", "scale", "", "fromDegrees", "yaw", "pitch", "fromRadians", "getAngleBetween", "a", "b", "getPerpendicular", "base", "up", "back", "isZero", "", "epsilon", "lerp", "t", "lerpUnclamped", "max", "min", "setLength", "length", "MechanicsCore"})
public final class VectorUtil {
    @NotNull
    public static final VectorUtil INSTANCE = new VectorUtil();
    @NotNull
    private static final ImmutableVector ZERO = new ImmutableVector(0, 0, 0);
    @NotNull
    private static final ImmutableVector UP = new ImmutableVector(0, 1, 0);
    @NotNull
    private static final ImmutableVector DOWN = new ImmutableVector(0, -1, 0);
    @NotNull
    private static final ImmutableVector NORTH = new ImmutableVector(0, 0, -1);
    @NotNull
    private static final ImmutableVector SOUTH = new ImmutableVector(0, 0, 1);
    @NotNull
    private static final ImmutableVector EAST = new ImmutableVector(1, 0, 0);
    @NotNull
    private static final ImmutableVector WEST = new ImmutableVector(-1, 0, 0);

    private VectorUtil() {
    }

    @NotNull
    public final ImmutableVector getZERO() {
        return ZERO;
    }

    @NotNull
    public final ImmutableVector getUP() {
        return UP;
    }

    @NotNull
    public final ImmutableVector getDOWN() {
        return DOWN;
    }

    @NotNull
    public final ImmutableVector getNORTH() {
        return NORTH;
    }

    @NotNull
    public final ImmutableVector getSOUTH() {
        return SOUTH;
    }

    @NotNull
    public final ImmutableVector getEAST() {
        return EAST;
    }

    @NotNull
    public final ImmutableVector getWEST() {
        return WEST;
    }

    @JvmStatic
    @NotNull
    public static final Vector setLength(@NotNull Vector vector, double length) {
        Intrinsics.checkNotNullParameter((Object)vector, (String)"vector");
        double currentLength = vector.length();
        if (NumberExtensionsKt.approximately$default(currentLength, 0.0, 0.0, 2, null)) {
            throw new IllegalArgumentException("Cannot set the length of a zero-length vector");
        }
        Vector vector2 = vector.multiply(length / currentLength);
        Intrinsics.checkNotNullExpressionValue((Object)vector2, (String)"multiply(...)");
        return vector2;
    }

    @JvmStatic
    @NotNull
    public static final Vector addScaledVector(@NotNull Vector vector, @NotNull Vector other, double scale) {
        Intrinsics.checkNotNullParameter((Object)vector, (String)"vector");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        vector.setX(vector.getX() + other.getX() * scale);
        vector.setY(vector.getY() + other.getY() * scale);
        vector.setZ(vector.getZ() + other.getZ() * scale);
        return vector;
    }

    @JvmStatic
    @NotNull
    public static final Vector fromDegrees(double yaw, double pitch) {
        double yawRad = Math.toRadians(yaw);
        double pitchRad = Math.toRadians(pitch);
        return VectorUtil.fromRadians(yawRad, pitchRad);
    }

    @JvmStatic
    @NotNull
    public static final Vector fromRadians(double yaw, double pitch) {
        double cosPitch = Math.cos(pitch);
        double x = Math.sin(yaw) * -cosPitch;
        double y = -Math.sin(pitch);
        double z = Math.cos(yaw) * cosPitch;
        return new Vector(x, y, z);
    }

    @JvmStatic
    @NotNull
    public static final Vector lerp(@NotNull Vector a, @NotNull Vector b, double t) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        double x = NumberUtil.lerp(a.getX(), b.getX(), t);
        double y = NumberUtil.lerp(a.getY(), b.getY(), t);
        double z = NumberUtil.lerp(a.getZ(), b.getZ(), t);
        return new Vector(x, y, z);
    }

    @JvmStatic
    @NotNull
    public static final Vector lerpUnclamped(@NotNull Vector a, @NotNull Vector b, double t) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        double x = NumberUtil.lerpUnclamped(a.getX(), b.getX(), t);
        double y = NumberUtil.lerpUnclamped(a.getY(), b.getY(), t);
        double z = NumberUtil.lerpUnclamped(a.getZ(), b.getZ(), t);
        return new Vector(x, y, z);
    }

    @JvmStatic
    @NotNull
    public static final Vector min(@NotNull Vector a, @NotNull Vector b) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        double x = Math.min(a.getX(), b.getX());
        double y = Math.min(a.getY(), b.getY());
        double z = Math.min(a.getZ(), b.getZ());
        return new Vector(x, y, z);
    }

    @JvmStatic
    @NotNull
    public static final Vector max(@NotNull Vector a, @NotNull Vector b) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        double x = Math.max(a.getX(), b.getX());
        double y = Math.max(a.getY(), b.getY());
        double z = Math.max(a.getZ(), b.getZ());
        return new Vector(x, y, z);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Vector getPerpendicular(@NotNull Vector base, @NotNull Vector up, @NotNull Vector back) {
        Intrinsics.checkNotNullParameter((Object)base, (String)"base");
        Intrinsics.checkNotNullParameter((Object)up, (String)"up");
        Intrinsics.checkNotNullParameter((Object)back, (String)"back");
        if (VectorUtil.isZero$default(base, 0.0, 2, null)) {
            throw new IllegalArgumentException("Cannot get a perpendicular vector of a zero-length vector");
        }
        Vector vector = base.getCrossProduct(up);
        Intrinsics.checkNotNullExpressionValue((Object)vector, (String)"getCrossProduct(...)");
        Vector cross = vector;
        if (cross.lengthSquared() < 1.0E-6) {
            Vector vector2 = base.getCrossProduct(back);
            Intrinsics.checkNotNullExpressionValue((Object)vector2, (String)"getCrossProduct(...)");
            return vector2;
        }
        return cross;
    }

    public static /* synthetic */ Vector getPerpendicular$default(Vector vector, Vector vector2, Vector vector3, int n, Object object) {
        if ((n & 2) != 0) {
            vector2 = UP;
        }
        if ((n & 4) != 0) {
            vector3 = SOUTH;
        }
        return VectorUtil.getPerpendicular(vector, vector2, vector3);
    }

    @JvmStatic
    public static final double getAngleBetween(@NotNull Vector a, @NotNull Vector b) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        double lengthsProduct = Math.sqrt(a.lengthSquared() * b.lengthSquared());
        if (NumberExtensionsKt.approximately$default(lengthsProduct, 0.0, 0.0, 2, null)) {
            return 0.0;
        }
        double cosTheta = a.dot(b) / lengthsProduct;
        cosTheta = NumberExtensionsKt.clamp(cosTheta, -1.0, 1.0);
        return Math.acos(cosTheta);
    }

    @JvmStatic
    @JvmOverloads
    public static final boolean isZero(@NotNull Vector a, double epsilon) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        return NumberExtensionsKt.approximately(a.getX(), 0.0, epsilon) && NumberExtensionsKt.approximately(a.getY(), 0.0, epsilon) && NumberExtensionsKt.approximately(a.getZ(), 0.0, epsilon);
    }

    public static /* synthetic */ boolean isZero$default(Vector vector, double d, int n, Object object) {
        if ((n & 2) != 0) {
            d = 1.0E-6;
        }
        return VectorUtil.isZero(vector, d);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Vector getPerpendicular(@NotNull Vector base, @NotNull Vector up) {
        Intrinsics.checkNotNullParameter((Object)base, (String)"base");
        Intrinsics.checkNotNullParameter((Object)up, (String)"up");
        return VectorUtil.getPerpendicular$default(base, up, null, 4, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Vector getPerpendicular(@NotNull Vector base) {
        Intrinsics.checkNotNullParameter((Object)base, (String)"base");
        return VectorUtil.getPerpendicular$default(base, null, null, 6, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final boolean isZero(@NotNull Vector a) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        return VectorUtil.isZero$default(a, 0.0, 2, null);
    }
}

