/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.core.utils;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import me.deecaad.core.utils.NumberExtensionsKt;
import me.deecaad.core.utils.VectorUtil;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0007\u001a\u001a\u0010\u0000\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0012\u0010\u0005\u001a\u00020\u0004*\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001\u001a\u001e\u0010\u0006\u001a\u00020\u0001*\u00020\u00012\b\b\u0002\u0010\u0007\u001a\u00020\u00012\b\b\u0002\u0010\b\u001a\u00020\u0001\u001a\u0012\u0010\t\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\n\u001a\u00020\u0004\u00a8\u0006\u000b"}, d2={"addScaledVector", "Lorg/bukkit/util/Vector;", "other", "scale", "", "getAngleBetween", "getPerpendicular", "up", "back", "setLength", "length", "MechanicsCore"})
public final class VectorExtensionsKt {
    @NotNull
    public static final Vector addScaledVector(@NotNull Vector $this$addScaledVector, @NotNull Vector other, double scale) {
        Intrinsics.checkNotNullParameter((Object)$this$addScaledVector, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        $this$addScaledVector.setX($this$addScaledVector.getX() + other.getX() * scale);
        $this$addScaledVector.setY($this$addScaledVector.getY() + other.getY() * scale);
        $this$addScaledVector.setZ($this$addScaledVector.getZ() + other.getZ() * scale);
        return $this$addScaledVector;
    }

    @NotNull
    public static final Vector setLength(@NotNull Vector $this$setLength, double length) {
        Intrinsics.checkNotNullParameter((Object)$this$setLength, (String)"<this>");
        double currentLength = $this$setLength.length();
        if (NumberExtensionsKt.approximately$default(currentLength, 0.0, 0.0, 2, null)) {
            throw new IllegalArgumentException("Cannot set the length of a zero-length vector");
        }
        Vector vector = $this$setLength.multiply(length / currentLength);
        Intrinsics.checkNotNullExpressionValue((Object)vector, (String)"multiply(...)");
        return vector;
    }

    @NotNull
    public static final Vector getPerpendicular(@NotNull Vector $this$getPerpendicular, @NotNull Vector up, @NotNull Vector back) {
        Intrinsics.checkNotNullParameter((Object)$this$getPerpendicular, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)up, (String)"up");
        Intrinsics.checkNotNullParameter((Object)back, (String)"back");
        if (VectorUtil.isZero$default($this$getPerpendicular, 0.0, 2, null)) {
            throw new IllegalArgumentException("Cannot get a perpendicular vector of a zero-length vector");
        }
        Vector vector = $this$getPerpendicular.getCrossProduct(up);
        Intrinsics.checkNotNullExpressionValue((Object)vector, (String)"getCrossProduct(...)");
        Vector cross = vector;
        if (cross.lengthSquared() < 1.0E-6) {
            Vector vector2 = $this$getPerpendicular.getCrossProduct(back);
            Intrinsics.checkNotNullExpressionValue((Object)vector2, (String)"getCrossProduct(...)");
            return vector2;
        }
        return cross;
    }

    public static /* synthetic */ Vector getPerpendicular$default(Vector vector, Vector vector2, Vector vector3, int n, Object object) {
        if ((n & 1) != 0) {
            vector2 = VectorUtil.INSTANCE.getUP();
        }
        if ((n & 2) != 0) {
            vector3 = VectorUtil.INSTANCE.getSOUTH();
        }
        return VectorExtensionsKt.getPerpendicular(vector, vector2, vector3);
    }

    public static final double getAngleBetween(@NotNull Vector $this$getAngleBetween, @NotNull Vector other) {
        Intrinsics.checkNotNullParameter((Object)$this$getAngleBetween, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return VectorUtil.getAngleBetween($this$getAngleBetween, other);
    }
}

