/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.core.utils;

import java.util.function.IntFunction;
import me.deecaad.core.MechanicsCore;
import me.deecaad.core.utils.MinecraftVersions;
import me.deecaad.core.utils.StringUtil;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.Style;
import org.bukkit.map.MapFont;
import org.bukkit.map.MinecraftFont;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class TableBuilder {
    public static final TableConstraints DEFAULT_CONSTRAINTS = new TableConstraints(8, 2, 320);
    public static final MapFont DEFAULT_FONT = MinecraftFont.Font;
    private TableConstraints constraints = DEFAULT_CONSTRAINTS;
    private MapFont font = DEFAULT_FONT;
    private String header;
    private TextComponent left;
    private TextComponent right;
    private char fillChar;
    private char elementChar = '\u0000';
    private boolean attemptSinglePixelFix;
    private Style headerStyle;
    private Style fillCharStyle;
    private Style elementCharStyle = this.elementStyle = Style.empty();
    private Style elementStyle;
    private IntFunction<TextComponent> supplier;

    public TableBuilder() {
        this.fillCharStyle = this.elementStyle;
        this.headerStyle = this.elementStyle;
    }

    public TableBuilder withConstraints(TableConstraints constraints) {
        this.constraints = constraints;
        return this;
    }

    public TableBuilder withFont(MapFont font) {
        this.font = font;
        return this;
    }

    public TableBuilder withHeader(String header) {
        this.header = header;
        return this;
    }

    public TableBuilder withLeft(TextComponent left) {
        this.left = left;
        return this;
    }

    public TableBuilder withRight(TextComponent right) {
        this.right = right;
        return this;
    }

    public TableBuilder withFillChar(char fillChar) {
        this.fillChar = fillChar;
        return this;
    }

    public TableBuilder withElementChar(char elementChar) {
        this.elementChar = elementChar;
        return this;
    }

    public TableBuilder withHeaderStyle(Style style) {
        this.headerStyle = style;
        return this;
    }

    public TableBuilder withElementStyle(Style style) {
        this.elementStyle = style;
        return this;
    }

    public TableBuilder withElementCharStyle(Style style) {
        this.elementCharStyle = style;
        return this;
    }

    public TableBuilder withFillCharStyle(Style style) {
        this.fillCharStyle = style;
        return this;
    }

    public TableBuilder withSupplier(IntFunction<TextComponent> supplier) {
        this.supplier = supplier;
        return this;
    }

    public TableBuilder withAttemptSinglePixelFix() {
        this.attemptSinglePixelFix = true;
        return this;
    }

    public TextComponent build() {
        TextComponent.Builder builder = Component.text();
        if (this.header != null && !this.header.isEmpty()) {
            builder.append((Component)this.buildHeader());
            builder.append((Component)Component.newline());
        }
        String prefix = this.elementChar == '\u0000' ? "" : this.elementChar + " ";
        int cellSize = this.constraints.pixels / this.constraints.columns - this.font.getWidth(prefix);
        for (int i = 0; i < this.constraints.rows * this.constraints.columns; ++i) {
            TextComponent text = this.supplier.apply(i);
            if (text == null) {
                if (i % this.constraints.columns == 0) break;
                builder.append((Component)Component.newline());
                break;
            }
            StringBuilder cell = new StringBuilder(text.content());
            boolean deleteCell = false;
            int originalLength = cell.length();
            if (cell.length() == 0) {
                deleteCell = true;
                for (Component component : text.children()) {
                    cell.append(((TextComponent)component).content());
                }
                originalLength = cell.length();
            }
            MechanicsCore.debug.debug("TableBuild :: " + i);
            MechanicsCore.debug.debug("TableBuild :: CELL BEFORE :: '" + String.valueOf(cell) + "'");
            int count = 0;
            if (i % this.constraints.columns != this.constraints.columns - 1) {
                while (this.getWidth(prefix + String.valueOf(cell)) < cellSize) {
                    cell.append(' ');
                }
                while (this.getWidth(prefix + String.valueOf(cell)) > cellSize) {
                    cell.setLength(cell.length() - 1);
                }
                while (this.attemptSinglePixelFix && this.getWidth(prefix + String.valueOf(cell) + StringUtil.repeat("|", count)) < cellSize) {
                    ++count;
                }
            }
            if (deleteCell) {
                cell = new StringBuilder(cell.substring(Math.min(originalLength, cell.length())));
            }
            MechanicsCore.debug.debug("TableBuild :: CELL AFTER  :: '" + String.valueOf(cell) + "'");
            MechanicsCore.debug.debug("TableBuild :: COMBINED    :: '" + prefix + String.valueOf(cell) + StringUtil.repeat("|", count) + "'");
            text = deleteCell ? (TextComponent)text.append((Component)Component.text((String)cell.toString())) : (TextComponent)text.content(cell.toString()).style(text.style().merge(this.elementStyle));
            builder.append(Component.text((String)prefix).style(this.elementCharStyle));
            builder.append((Component)text);
            builder.append(Component.text((String)StringUtil.repeat("|", count)).style(this.elementCharStyle));
            if (i % this.constraints.columns != this.constraints.columns - 1) continue;
            builder.append((Component)Component.newline());
        }
        if (this.left != null && this.right != null) {
            builder.append((Component)this.buildFooter());
        }
        return (TextComponent)builder.build();
    }

    public TextComponent buildHeader() {
        StringBuilder a = new StringBuilder();
        while (this.getWidth(String.valueOf(a) + " " + this.header + " " + String.valueOf(a)) < this.constraints.pixels) {
            a.append(this.fillChar);
        }
        a.setLength(a.length() - 1);
        TextComponent.Builder builder = Component.text();
        builder.append(Component.text().content(a.toString()).style(this.fillCharStyle));
        builder.append(Component.text().content(" " + this.header + " ").style(this.headerStyle));
        builder.append(Component.text().content(a.toString()).style(this.fillCharStyle));
        return (TextComponent)builder.build();
    }

    public TextComponent buildFooter() {
        StringBuilder a = new StringBuilder();
        String footer = " " + this.left.content() + StringUtil.repeat(" ", this.header.length()) + this.right.content() + " ";
        while (this.getWidth(String.valueOf(a) + " " + footer + " " + String.valueOf(a)) < this.constraints.pixels) {
            a.append(this.fillChar);
        }
        a.setLength(a.length() - 1);
        TextComponent.Builder builder = Component.text();
        builder.append(Component.text().content(a.toString()).style(this.fillCharStyle));
        builder.append((Component)Component.text((String)" "));
        builder.append((Component)this.left);
        builder.append((Component)Component.text((String)StringUtil.repeat(" ", this.header.length())));
        builder.append((Component)this.right);
        builder.append((Component)Component.text((String)" "));
        builder.append(Component.text().content(a.toString()).style(this.fillCharStyle));
        return (TextComponent)builder.build();
    }

    private int getWidth(String str) {
        int width = this.font.getWidth(str);
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c != ' ' || MinecraftVersions.NETHER_UPDATE.isAtLeast()) continue;
            ++width;
        }
        return width;
    }

    public record TableConstraints(int rows, int columns, int pixels) {
        @Contract(pure=true)
        @NotNull
        public TableConstraints setRows(int rows) {
            return new TableConstraints(rows, this.columns, this.pixels);
        }

        @Contract(pure=true)
        @NotNull
        public TableConstraints setColumns(int columns) {
            return new TableConstraints(this.rows, columns, this.pixels);
        }

        @Contract(pure=true)
        @NotNull
        public TableConstraints setPixels(int pixels) {
            return new TableConstraints(this.rows, this.columns, pixels);
        }
    }

    public record Line(char c, Style style) {
        public Component build() {
            StringBuilder builder = new StringBuilder();
            while (this.getWidth(builder.toString()) < DEFAULT_CONSTRAINTS.pixels()) {
                builder.append(this.c);
            }
            builder.setLength(builder.length() - 1);
            return Component.text((String)builder.toString()).style(this.style);
        }

        private int getWidth(String str) {
            int width = DEFAULT_FONT.getWidth(str);
            for (int i = 0; i < str.length(); ++i) {
                char c = str.charAt(i);
                if (c != ' ' || MinecraftVersions.NETHER_UPDATE.isAtLeast()) continue;
                ++width;
            }
            return width;
        }
    }
}

