/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.core.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.intellij.lang.annotations.RegExp;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\t\n\u0002\u0010\b\n\u0000\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u0004H\u0007J\u0010\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u0004H\u0007J\u0010\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0004H\u0007J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0013H\u0007J\u001e\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u00042\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00040\u0017H\u0007J\"\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u00112\b\b\u0002\u0010\u001b\u001a\u00020\u0019H\u0007J\u001c\u0010\u001c\u001a\u0004\u0018\u00010\u00042\b\b\u0001\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0004H\u0007J\u001a\u0010\u001c\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u000f\u001a\u00020\u0004H\u0007J\u0010\u0010\u001f\u001a\u00020\u00042\u0006\u0010 \u001a\u00020\u0011H\u0007J\u0018\u0010!\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020\u0011H\u0007J\u0010\u0010#\u001a\u00020\u00042\u0006\u0010$\u001a\u00020\u0004H\u0007J\u0010\u0010%\u001a\u00020\u00042\u0006\u0010$\u001a\u00020\u0004H\u0007J\u0016\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00040'2\u0006\u0010\u000f\u001a\u00020\u0004H\u0007J\u0016\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00040'2\u0006\u0010\u000f\u001a\u00020\u0004H\u0007J\u0016\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00040'2\u0006\u0010\u000f\u001a\u00020\u0004H\u0007J\u0010\u0010*\u001a\u00020+2\u0006\u0010\u000f\u001a\u00020\u0004H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\bR\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lme/deecaad/core/utils/StringUtil;", "", "()V", "LOWER_ALPHABET", "", "MINECRAFT_COLOR_CODES", "SUFFIXES", "", "[Ljava/lang/String;", "VALID_HEX", "camelToSnake", "camel", "colorAdventure", "value", "colorBukkit", "str", "countOccurrences", "", "char", "", "didYouMean", "input", "possibilities", "", "isEscaped", "", "index", "includeBackslash", "match", "regex", "Lkotlin/text/Regex;", "ordinal", "number", "repeat", "times", "snakeToReadable", "snake", "snakeToUpperSnake", "split", "", "splitAfterWord", "splitCapitalLetters", "toCharTable", "", "MechanicsCore"})
@SourceDebugExtension(value={"SMAP\nStringUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StringUtil.kt\nme/deecaad/core/utils/StringUtil\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,459:1\n1099#2,3:460\n766#3:463\n857#3,2:464\n*S KotlinDebug\n*F\n+ 1 StringUtil.kt\nme/deecaad/core/utils/StringUtil\n*L\n29#1:460,3\n294#1:463\n294#1:464,2\n*E\n"})
public final class StringUtil {
    @NotNull
    public static final StringUtil INSTANCE = new StringUtil();
    @NotNull
    public static final String LOWER_ALPHABET = "abcdefghijklmnopqrstuvwxyz";
    @NotNull
    public static final String VALID_HEX = "0123456789AaBbCcDdEeFf";
    @NotNull
    public static final String MINECRAFT_COLOR_CODES = "0123456789AaBbCcDdEeFfKkLlMmNnOoRrXx";
    @NotNull
    private static final String[] SUFFIXES;

    private StringUtil() {
    }

    @JvmStatic
    public static final int countOccurrences(@NotNull String str, char c) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        CharSequence $this$count$iv = str;
        boolean $i$f$count = false;
        int count$iv = 0;
        for (int i = 0; i < $this$count$iv.length(); ++i) {
            char element$iv;
            char it = element$iv = $this$count$iv.charAt(i);
            boolean bl = false;
            if (!(it == c)) continue;
            ++count$iv;
        }
        return count$iv;
    }

    @JvmStatic
    @NotNull
    public static final String repeat(@NotNull String str, int times) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        if (((CharSequence)str).length() == 0 || times <= 0) {
            return "";
        }
        return StringsKt.repeat((CharSequence)str, (int)times);
    }

    @JvmStatic
    @JvmOverloads
    public static final boolean isEscaped(@NotNull String str, int index, boolean includeBackslash) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        if (index == 0) {
            return false;
        }
        int backslashes = 0;
        for (int i = index - 1; -1 < i && str.charAt(i) == '\\'; --i) {
            ++backslashes;
        }
        return backslashes % 2 == 1 || !includeBackslash && str.charAt(index) == '\\';
    }

    public static /* synthetic */ boolean isEscaped$default(String string, int n, boolean bl, int n2, Object object) {
        if ((n2 & 4) != 0) {
            bl = false;
        }
        return StringUtil.isEscaped(string, n, bl);
    }

    @JvmStatic
    @Nullable
    public static final String match(@RegExp @NotNull String regex, @NotNull String str) {
        Intrinsics.checkNotNullParameter((Object)regex, (String)"regex");
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        return StringUtil.match(new Regex(regex), str);
    }

    @JvmStatic
    @Nullable
    public static final String match(@NotNull Regex regex, @NotNull String str) {
        MatchResult match;
        Intrinsics.checkNotNullParameter((Object)regex, (String)"regex");
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        MatchResult matchResult = match = Regex.find$default((Regex)regex, (CharSequence)str, (int)0, (int)2, null);
        return matchResult != null ? matchResult.getValue() : null;
    }

    @JvmStatic
    @NotNull
    public static final String colorBukkit(@NotNull String str) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        StringBuilder result = new StringBuilder(str.length());
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c != '&') {
                result.append(c);
                continue;
            }
            if (i != 0 && str.charAt(i - 1) == '\\') {
                result.setCharAt(result.length() - 1, '&');
                continue;
            }
            if (i + 1 != str.length()) {
                if (StringsKt.contains$default((CharSequence)MINECRAFT_COLOR_CODES, (char)str.charAt(i + 1), (boolean)false, (int)2, null)) {
                    result.append('\u00a7');
                    continue;
                }
                if (str.charAt(i + 1) == '#') {
                    int bound = i + 7;
                    if (bound > str.length()) continue;
                    result.append('\u00a7').append('x');
                    i += 2;
                    while (i <= bound) {
                        result.append('\u00a7').append(str.charAt(i));
                        ++i;
                    }
                    --i;
                    continue;
                }
                result.append('&');
                continue;
            }
            result.append('&');
        }
        String string = result.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @JvmStatic
    @NotNull
    public static final String colorAdventure(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        String value2 = StringsKt.replace$default((String)value, (char)'\u00a7', (char)'&', (boolean)false, (int)4, null);
        Map replacements = new HashMap();
        replacements.put("&0", "<black>");
        replacements.put("&1", "<dark_blue>");
        replacements.put("&2", "<dark_green>");
        replacements.put("&3", "<dark_aqua>");
        replacements.put("&4", "<dark_red>");
        replacements.put("&5", "<dark_purple>");
        replacements.put("&6", "<gold>");
        replacements.put("&7", "<gray>");
        replacements.put("&8", "<dark_gray>");
        replacements.put("&9", "<blue>");
        replacements.put("&(a|A)", "<green>");
        replacements.put("&(b|B)", "<aqua>");
        replacements.put("&(c|C)", "<red>");
        replacements.put("&(d|D)", "<light_purple>");
        replacements.put("&(e|E)", "<yellow>");
        replacements.put("&(f|F)", "<white>");
        replacements.put("&(k|K)", "<obfuscated>");
        replacements.put("&(l|L)", "<bold>");
        replacements.put("&(m|M)", "<strikethrough>");
        replacements.put("&(n|N)", "<underline>");
        replacements.put("&(o|O)", "<italic>");
        replacements.put("&(r|R)", "<reset>");
        Pattern regex = Pattern.compile("&#([a-f]|[A-F]|\\d){6}");
        Matcher matcher = regex.matcher(value2);
        StringBuilder builder = new StringBuilder();
        while (matcher.find()) {
            String match = matcher.group(0);
            Intrinsics.checkNotNull((Object)match);
            String string = match.substring(1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String replacement = "<" + string + ">";
            matcher.appendReplacement(builder, replacement);
        }
        matcher.appendTail(builder);
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        value2 = string;
        for (Map.Entry entry : replacements.entrySet()) {
            String key = (String)entry.getKey();
            String value1 = (String)entry.getValue();
            CharSequence charSequence = value2;
            value2 = new Regex(key).replace(charSequence, value1);
        }
        return value2;
    }

    @JvmStatic
    @NotNull
    public static final String ordinal(int number) {
        int n = number % 100;
        return (11 <= n ? n < 14 : false) ? number + "th" : number + SUFFIXES[number % 10];
    }

    @JvmStatic
    @NotNull
    public static final List<String> splitCapitalLetters(@NotNull String str) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        CharSequence charSequence = str;
        Regex regex = new Regex("(?<!(^|[A-Z]))(?=[A-Z])|(?<!^)(?=[A-Z][a-z])");
        int n = 0;
        return regex.split(charSequence, n);
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final List<String> splitAfterWord(@NotNull String str) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        CharSequence charSequence = str;
        Regex regex = new Regex("(?!\\S+) |(?!\\S+)");
        int n = 0;
        Iterable $this$filter$iv = regex.split(charSequence, n);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            boolean bl2 = !StringsKt.isBlank((CharSequence)it);
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @JvmStatic
    @NotNull
    public static final List<String> split(@NotNull String str) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        String str2 = str;
        boolean addDash = false;
        if (StringsKt.startsWith$default((String)str2, (String)"-", (boolean)false, (int)2, null)) {
            addDash = true;
            String string = str2.substring(1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            str2 = string;
        }
        CharSequence charSequence = str2;
        Regex regex = new Regex("[~ ]+|(?<![~ -])-");
        int n = 0;
        List split = CollectionsKt.toMutableList((Collection)regex.split(charSequence, n));
        if (addDash) {
            split.set(0, "-" + split.get(0));
        }
        return split;
    }

    @JvmStatic
    @NotNull
    public static final String camelToSnake(@NotNull String camel) {
        Intrinsics.checkNotNullParameter((Object)camel, (String)"camel");
        StringBuilder builder = new StringBuilder();
        int n = camel.length();
        for (int i = 0; i < n; ++i) {
            char c = camel.charAt(i);
            if (i != 0 && Character.isUpperCase(c)) {
                builder.append('_');
            }
            builder.append(Character.toLowerCase(c));
        }
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @JvmStatic
    @NotNull
    public static final String snakeToUpperSnake(@NotNull String snake) {
        Intrinsics.checkNotNullParameter((Object)snake, (String)"snake");
        StringBuilder builder = new StringBuilder();
        int n = snake.length();
        for (int i = 0; i < n; ++i) {
            char c = snake.charAt(i);
            if (i == 0 || snake.charAt(i - 1) == '_') {
                builder.append(Character.toUpperCase(c));
                continue;
            }
            builder.append(Character.toLowerCase(c));
        }
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @JvmStatic
    @NotNull
    public static final String snakeToReadable(@NotNull String snake) {
        Intrinsics.checkNotNullParameter((Object)snake, (String)"snake");
        StringBuilder builder = new StringBuilder();
        int n = snake.length();
        for (int i = 0; i < n; ++i) {
            char c = snake.charAt(i);
            if (c == '_') {
                builder.append(' ');
                continue;
            }
            if (i == 0 || snake.charAt(i - 1) == '_') {
                builder.append(Character.toUpperCase(c));
                continue;
            }
            builder.append(Character.toLowerCase(c));
        }
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @JvmStatic
    @NotNull
    public static final String didYouMean(@NotNull String input, @NotNull Iterable<String> possibilities) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter(possibilities, (String)"possibilities");
        String closest = null;
        int closestDistance = Integer.MAX_VALUE;
        int[] table = StringUtil.toCharTable(input);
        for (String possibility : possibilities) {
            int[] localTable = StringUtil.toCharTable(possibility);
            int localDifference = Math.abs(input.length() - possibility.length());
            int n = table.length;
            for (int i = 0; i < n; ++i) {
                localDifference += Math.abs(table[i] - localTable[i]);
            }
            if (localDifference >= closestDistance) continue;
            closest = possibility;
            closestDistance = localDifference;
        }
        String string = closest;
        if (string == null) {
            throw new IllegalArgumentException("You passed 0 possibilities to the didYouMean function.");
        }
        return string;
    }

    @JvmStatic
    @NotNull
    public static final int[] toCharTable(@NotNull String str) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        String string = str.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        String str2 = string;
        int[] table = new int[26];
        int n = str2.length();
        for (int i = 0; i < n; ++i) {
            char c = str2.charAt(i);
            int index = Character.toLowerCase(c) - 97;
            if (index < 0 || index >= table.length) continue;
            int n2 = table[index];
            table[index] = n2 + 1;
        }
        return table;
    }

    @JvmStatic
    @JvmOverloads
    public static final boolean isEscaped(@NotNull String str, int index) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        return StringUtil.isEscaped$default(str, index, false, 4, null);
    }

    static {
        String[] stringArray = new String[]{"th", "st", "nd", "rd", "th", "th", "th", "th", "th", "th"};
        SUFFIXES = stringArray;
    }
}

