/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.core.utils;

import java.util.Objects;
import me.deecaad.core.utils.NumberUtil;
import me.deecaad.core.utils.VectorUtil;
import org.bukkit.util.Vector;

public class Quaternion
implements Cloneable {
    public static final double EPSILON = 1.11E-16;
    static final Vector UP = new Vector(0, 1, 0);
    static final Vector DOWN = new Vector(0, -1, 0);
    static final Vector LEFT = new Vector(1, 0, 0);
    static final Vector RIGHT = new Vector(-1, 0, 0);
    static final Vector FORWARD = new Vector(0, 0, 1);
    static final Vector BACKWARD = new Vector(0, 0, -1);
    private double x;
    private double y;
    private double z;
    private double w;

    private Quaternion() {
    }

    private Quaternion(Quaternion quaternion) {
        this.x = quaternion.x;
        this.y = quaternion.y;
        this.z = quaternion.z;
        this.w = quaternion.w;
    }

    private Quaternion(double x, double y, double z, double w) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
    }

    public Vector getEulerAngles() {
        Vector temp = new Vector();
        double test = this.x * this.y + this.z * this.w;
        double sqx = this.x * this.x;
        double sqy = this.y * this.y;
        double sqz = this.z * this.z;
        double sqw = this.w * this.w;
        double unit = sqx + sqy + sqz + sqw;
        if (test > 0.499 * unit) {
            temp.setY(2.0 * Math.atan2(this.x, this.w));
            temp.setZ(1.5707964f);
            temp.setX(0);
        } else if (test < -0.499 * unit) {
            temp.setY(-2.0 * Math.atan2(this.x, this.w));
            temp.setZ(-1.5707964f);
            temp.setX(0);
        } else {
            temp.setY(Math.atan2(2.0 * this.y * this.w - 2.0 * this.x * this.z, sqx - sqy - sqz + sqw));
            temp.setZ(Math.asin(2.0 * test / unit));
            temp.setX(Math.atan2(2.0 * this.x * this.w - 2.0 * this.y * this.z, -sqx + sqy - sqz + sqw));
        }
        return temp;
    }

    public Quaternion setEulerAngles(Vector angles) {
        double yaw = angles.getX();
        double pitch = angles.getY();
        double roll = angles.getZ();
        double angle = pitch / 2.0;
        double sinPitch = Math.sin(angle);
        double cosPitch = Math.cos(angle);
        angle = roll / 2.0;
        double sinRoll = Math.sin(angle);
        double cosRoll = Math.cos(angle);
        angle = yaw / 2.0;
        double sinYaw = Math.sin(angle);
        double cosYaw = Math.cos(angle);
        double cosRollXcosPitch = cosRoll * cosPitch;
        double sinRollXsinPitch = sinRoll * sinPitch;
        double cosRollXsinPitch = cosRoll * sinPitch;
        double sinRollXcosPitch = sinRoll * cosPitch;
        this.w = cosRollXcosPitch * cosYaw - sinRollXsinPitch * sinYaw;
        this.x = cosRollXcosPitch * sinYaw + sinRollXsinPitch * cosYaw;
        this.y = sinRollXcosPitch * cosYaw + cosRollXsinPitch * sinYaw;
        this.z = cosRollXsinPitch * cosYaw - sinRollXcosPitch * sinYaw;
        this.normalize();
        return this;
    }

    public Quaternion lerp(Quaternion other, double t) {
        t = NumberUtil.clamp01(t);
        if (this.equals(other)) {
            return this;
        }
        double dot = this.dot(other);
        if (dot < 0.0) {
            // empty if block
        }
        return this;
    }

    public Quaternion multiply(Quaternion other) {
        double a = this.x * other.w + this.y * other.z - this.z * other.y + this.w * other.x;
        double b = -this.x * other.z + this.y * other.w + this.z * other.x + this.w * other.y;
        double c = this.x * other.y - this.y * other.x + this.z * other.w + this.w * other.z;
        double d = -this.x * other.x - this.y * other.y - this.z * other.z + this.w * other.w;
        this.x = a;
        this.y = b;
        this.z = c;
        this.w = d;
        return this;
    }

    public Vector multiply(Vector vector) {
        double tempX = this.w * this.w * vector.getX() + 2.0 * this.y * this.w * vector.getZ() - 2.0 * this.z * this.w * vector.getY() + this.x * this.x * vector.getX() + 2.0 * this.y * this.x * vector.getY() + 2.0 * this.z * this.x * vector.getZ() - this.z * this.z * vector.getX() - this.y * this.y * vector.getX();
        double tempY = 2.0 * this.x * this.y * vector.getX() + this.y * this.y * vector.getY() + 2.0 * this.z * this.y * vector.getZ() + 2.0 * this.w * this.z * vector.getX() - this.z * this.z * vector.getY() + this.w * this.w * vector.getY() - 2.0 * this.x * this.w * vector.getZ() - this.x * this.x * vector.getY();
        double tempZ = 2.0 * this.x * this.z * vector.getX() + 2.0 * this.y * this.z * vector.getY() + this.z * this.z * vector.getZ() - 2.0 * this.w * this.y * vector.getX() - this.y * this.y * vector.getZ() + 2.0 * this.w * this.x * vector.getY() - this.x * this.x * vector.getZ() + this.w * this.w * vector.getZ();
        return new Vector(tempX, tempY, tempZ);
    }

    public double dot(Quaternion other) {
        return this.x * other.x + this.y * other.y + this.z * other.z + this.w * other.w;
    }

    public Quaternion inverse() {
        double length = this.dot(this);
        double inverse = 1.0 / length;
        this.x *= -inverse;
        this.y *= -inverse;
        this.z *= -inverse;
        this.w *= inverse;
        return this;
    }

    public Quaternion normalize() {
        double factor = Math.sqrt(this.dot(this));
        if (factor < 1.11E-16) {
            throw new IllegalArgumentException("Divide by 0");
        }
        this.x /= factor;
        this.y /= factor;
        this.z /= factor;
        this.w /= factor;
        return this;
    }

    protected Quaternion clone() {
        return new Quaternion(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Quaternion that = (Quaternion)o;
        return Double.compare(that.x, this.x) == 0 && Double.compare(that.y, this.y) == 0 && Double.compare(that.z, this.z) == 0 && Double.compare(that.w, this.w) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.x, this.y, this.z, this.w);
    }

    public boolean isUnit() {
        return this.dot(this) < 1.11E-16;
    }

    public boolean isPure() {
        return this.w < 1.11E-16;
    }

    public static Quaternion identity() {
        return new Quaternion(0.0, 0.0, 0.0, 1.0);
    }

    public static Quaternion lookAt(Vector direction, Vector up) {
        Vector x = up.getCrossProduct(direction).normalize();
        Vector y = direction.getCrossProduct(x).normalize();
        return Quaternion.fromAxis(x, y, direction);
    }

    public static Quaternion fromAxis(Vector right, Vector up, Vector forward) {
        double z;
        double y;
        double x;
        double w;
        double m00 = right.getX();
        double m01 = right.getY();
        double m02 = right.getZ();
        double m10 = up.getX();
        double m11 = up.getY();
        double m12 = up.getZ();
        double m20 = forward.getX();
        double m21 = forward.getY();
        double m22 = forward.getZ();
        double num8 = m00 + m11 + m22;
        if (num8 > 0.0) {
            double num = Math.sqrt(num8 + 1.0);
            w = num * 0.5;
            num = 0.5 / num;
            x = (m12 - m21) * num;
            y = (m20 - m02) * num;
            z = (m01 - m10) * num;
        } else if (m00 >= m11 && m00 >= m22) {
            double num7 = Math.sqrt(1.0 + m00 - m11 - m22);
            double num4 = 0.5 / num7;
            x = 0.5 * num7;
            y = (m01 + m10) * num4;
            z = (m02 + m20) * num4;
            w = (m12 - m21) * num4;
        } else if (m11 > m22) {
            double num6 = Math.sqrt(1.0 + m11 - m00 - m22);
            double num3 = 0.5 / num6;
            x = (m10 + m01) * num3;
            y = 0.5 * num6;
            z = (m21 + m12) * num3;
            w = (m20 - m02) * num3;
        } else {
            double num5 = Math.sqrt(1.0 + m22 - m00 - m11);
            double num2 = 0.5 / num5;
            x = (m20 + m02) * num2;
            y = (m21 + m12) * num2;
            z = 0.5 * num5;
            w = (m01 - m10) * num2;
        }
        return new Quaternion(x, y, z, w);
    }

    public static Quaternion fromTo(Vector from, Vector to) {
        Vector arbitrary;
        from = from.clone();
        Vector axis = from.crossProduct(to);
        double angle = VectorUtil.getAngleBetween(from, to);
        if ((VectorUtil.isZero(axis) || angle > 3.1401) && VectorUtil.isZero(axis = (arbitrary = from.crossProduct(RIGHT)).crossProduct(from))) {
            axis = UP;
        }
        return Quaternion.angleAxis(angle, axis);
    }

    public static Quaternion fromEuler(Vector angles) {
        return new Quaternion().setEulerAngles(angles);
    }

    public static Quaternion angleAxis(double angle, Vector axis) {
        if (VectorUtil.isZero(axis)) {
            throw new IllegalArgumentException("Divide by zero");
        }
        double s = Math.sin(angle / 2.0);
        double w = Math.cos(angle / 2.0);
        double x = axis.getX() * s;
        double y = axis.getY() * s;
        double z = axis.getZ() * s;
        return new Quaternion(x, y, z, w);
    }
}

