/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.core.utils;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.Map;
import java.util.jar.JarFile;
import me.deecaad.core.MechanicsCore;
import me.deecaad.core.utils.LogLevel;
import me.deecaad.core.utils.MinecraftVersions;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;

public final class FileUtil {
    private FileUtil() {
    }

    public static void copyResourcesTo(URL source, final Path target) {
        if (source == null) {
            throw new IllegalArgumentException("Resource was null, make sure you put in the correct path!");
        }
        try {
            final PathReference pathReference = PathReference.of(source.toURI());
            Files.walkFileTree(pathReference.path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    Path currentTarget = target.resolve(pathReference.path.relativize(dir).toString());
                    Files.createDirectories(currentTarget, new FileAttribute[0]);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Files.copy(file, target.resolve(pathReference.path.relativize(file).toString()), StandardCopyOption.REPLACE_EXISTING);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (Throwable e) {
            throw new InternalError(e);
        }
    }

    public JarFile getJarFile(Plugin plugin, File jar) {
        if (jar == null || !jar.exists()) {
            try {
                jar = new File(plugin.getClass().getProtectionDomain().getCodeSource().getLocation().getFile());
            }
            catch (SecurityException e) {
                try {
                    Method method = plugin.getClass().getDeclaredMethod("getFile", new Class[0]);
                    method.setAccessible(true);
                    jar = (File)method.invoke((Object)plugin, new Object[0]);
                }
                catch (Exception e1) {
                    MechanicsCore.debug.log(LogLevel.ERROR, "Failed to invoke JavaPlugin#getFile()", e1);
                }
            }
            if (jar == null) {
                MechanicsCore.debug.log(LogLevel.WARN, "Could not locate " + plugin.getDescription().getName() + " jar file...");
                throw new InternalError();
            }
        }
        try {
            return new JarFile(jar);
        }
        catch (IOException e) {
            MechanicsCore.debug.log(LogLevel.ERROR, "Failed to create jar file: " + String.valueOf(jar), e);
            throw new InternalError(e);
        }
    }

    public static void ensureDefaults(URL resource, File file) {
        YamlConfiguration from;
        if (resource == null) {
            throw new IllegalArgumentException("Resource was null, make sure you put in the correct path!");
        }
        FileUtil.ensureFile(resource, file);
        if (!MinecraftVersions.CAVES_AND_CLIFFS_2.isAtLeast()) {
            return;
        }
        try {
            from = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(resource.openStream(), StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            throw new InternalError(e);
        }
        YamlConfiguration to = YamlConfiguration.loadConfiguration((File)file);
        boolean madeChanges = false;
        for (String key : from.getKeys(true)) {
            if (to.contains(key)) continue;
            to.set(key, from.get(key));
            to.setComments(key, from.getComments(key));
            to.setInlineComments(key, from.getInlineComments(key));
            madeChanges = true;
        }
        try {
            if (madeChanges) {
                to.save(file);
            }
        }
        catch (IOException e) {
            throw new InternalError(e);
        }
    }

    public static void downloadFile(File target, String link, int connectionTime, int readTime) {
        try {
            HttpURLConnection connection = (HttpURLConnection)new URL(link).openConnection();
            connection.setInstanceFollowRedirects(true);
            connection.setConnectTimeout(connectionTime * 1000);
            connection.setReadTimeout(readTime * 1000);
            InputStream in = connection.getInputStream();
            Files.copy(in, target.toPath(), new CopyOption[0]);
            in.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void ensureFile(URL resource, File file) {
        if (!file.exists()) {
            try (BufferedInputStream in = new BufferedInputStream(resource.openStream());
                 FileOutputStream out = new FileOutputStream(file);){
                int data;
                while ((data = ((InputStream)in).read()) != -1) {
                    out.write(data);
                }
            }
            catch (IOException ex) {
                throw new InternalError(ex);
            }
        }
    }

    public record PathReference(Path path, FileSystem fileSystem) {
        public static PathReference of(URI resource) throws IOException {
            try {
                return new PathReference(Paths.get(resource), null);
            }
            catch (FileSystemNotFoundException e) {
                Map env = Collections.emptyMap();
                FileSystem fs = FileSystems.newFileSystem(resource, env);
                return new PathReference(fs.provider().getPath(resource), fs);
            }
        }
    }
}

