/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.core.utils;

import java.util.LinkedList;
import java.util.List;
import me.deecaad.core.MechanicsCore;
import me.deecaad.core.compatibility.CompatibilityAPI;
import me.deecaad.core.utils.MinecraftVersions;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public final class DistanceUtil {
    private DistanceUtil() {
    }

    public static int getRange() {
        int distance = Bukkit.getServer().getViewDistance();
        return distance << 4;
    }

    public static int getRange(@NotNull World world) {
        if (!MinecraftVersions.VILLAGE_AND_PILLAGE.isAtLeast()) {
            return DistanceUtil.getRange();
        }
        try {
            return world.getViewDistance() << 4;
        }
        catch (Throwable ex) {
            MechanicsCore.debug.error("Looks like you are on a CraftBukkit server! Skipping world.getViewDistance()");
            return DistanceUtil.getRange();
        }
    }

    public static List<Player> getPlayersInRange(@NotNull Location origin) {
        if (origin.getWorld() == null) {
            throw new IllegalArgumentException("origin.world cannot be null");
        }
        return DistanceUtil.getPlayersInRange(origin, -1.0, DistanceUtil.getRange(origin.getWorld()));
    }

    public static List<Player> getPlayersInRange(@NotNull Location origin, double min, double max) {
        World world = origin.getWorld();
        if (world == null) {
            throw new IllegalArgumentException("origin.world cannot be null");
        }
        double x1max = origin.getX() - max;
        double y1max = origin.getY() - max;
        double z1max = origin.getZ() - max;
        double x2max = origin.getX() + max;
        double y2max = origin.getY() + max;
        double z2max = origin.getZ() + max;
        double x1min = origin.getX() - min;
        double y1min = origin.getY() - min;
        double z1min = origin.getZ() - min;
        double x2min = origin.getX() + min;
        double y2min = origin.getY() + min;
        double z2min = origin.getZ() + min;
        LinkedList<Player> players = new LinkedList<Player>();
        for (Player player : world.getPlayers()) {
            Location pos = player.getLocation();
            if (!(pos.getX() > x1max) || !(pos.getX() < x2max) || !(pos.getY() > y1max) || !(pos.getY() < y2max) || !(pos.getZ() > z1max) || !(pos.getZ() < z2max) || min != -1.0 && pos.getX() > x1min && pos.getX() < x2min && pos.getY() > y1min && pos.getY() < y2min && pos.getZ() > z1min && pos.getZ() < z2min) continue;
            players.add(player);
        }
        return players;
    }

    public static void sendPacket(@NotNull Location origin, Object ... packets) {
        if (origin.getWorld() == null) {
            throw new IllegalArgumentException("Cannot have null world");
        }
        for (Player entity : DistanceUtil.getPlayersInRange(origin)) {
            if (entity.getType() != EntityType.PLAYER) continue;
            CompatibilityAPI.getCompatibility().sendPackets(entity, packets);
        }
    }
}

