/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.core.utils;

import java.util.logging.Logger;
import me.deecaad.core.utils.LogLevel;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class Debugger {
    private final Logger logger;
    private int level;
    private final boolean isPrintTraces;
    private int errors;
    public String msg = "MechanicsPlugin had %s error(s) in console.";
    public String permission = "mechanicscore.errorlog";
    public long updateTime = 300L;
    private final BukkitRunnable warningTask;
    private boolean hasStarted;

    public Debugger(Logger logger, int level) {
        this(logger, level, false);
    }

    public Debugger(Logger logger, int level, boolean isPrintTraces) {
        this.logger = logger;
        this.level = level;
        this.isPrintTraces = isPrintTraces;
        this.warningTask = new BukkitRunnable(){

            public void run() {
                if (Debugger.this.errors > 0) {
                    boolean alertedPlayer = false;
                    for (Player player : Bukkit.getServer().getOnlinePlayers()) {
                        if (!player.hasPermission(Debugger.this.permission)) continue;
                        alertedPlayer = true;
                        player.sendMessage(String.valueOf(ChatColor.RED) + String.format(Debugger.this.msg, Debugger.this.errors));
                    }
                    if (alertedPlayer) {
                        Debugger.this.errors = 0;
                    }
                }
            }
        };
    }

    public Logger getLogger() {
        return this.logger;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public boolean canLog(LogLevel level) {
        return level.shouldPrint(this.level);
    }

    public void debug(String ... msg) {
        if (this.canLog(LogLevel.DEBUG)) {
            this.log(LogLevel.DEBUG, msg);
        }
    }

    public void info(String ... msg) {
        if (this.canLog(LogLevel.INFO)) {
            this.log(LogLevel.INFO, msg);
        }
    }

    public void warn(String ... msg) {
        if (this.canLog(LogLevel.WARN)) {
            this.log(LogLevel.WARN, msg);
        }
    }

    public void error(String ... msg) {
        if (this.canLog(LogLevel.ERROR)) {
            this.log(LogLevel.ERROR, msg);
        }
    }

    public void log(LogLevel level, String ... msg) {
        if (!this.canLog(level)) {
            return;
        }
        for (String str : msg) {
            this.logger.log(level.getParallel(), str);
        }
        if (level == LogLevel.ERROR || level == LogLevel.WARN) {
            if (this.isPrintTraces) {
                this.log(level, new Throwable());
            }
            if (level == LogLevel.ERROR) {
                ++this.errors;
            }
        }
    }

    public void log(LogLevel level, Throwable error) {
        if (!this.canLog(level)) {
            return;
        }
        this.logger.log(level.getParallel(), "", error);
    }

    public void log(LogLevel level, String msg, Throwable error) {
        if (!this.canLog(level)) {
            return;
        }
        this.logger.log(level.getParallel(), msg, error);
    }

    public void validate(boolean bool, String ... messages) {
        if (!bool) {
            this.log(LogLevel.ERROR, messages);
        }
    }

    public void validate(LogLevel level, boolean bool, String ... messages) {
        if (!bool) {
            this.log(level, messages);
        }
    }

    public synchronized void start(Plugin plugin) {
        if (this.hasStarted) {
            return;
        }
        this.warningTask.runTaskTimerAsynchronously(plugin, 10L, this.updateTime);
        this.hasStarted = true;
    }
}

