/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.core.placeholder;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.clip.placeholderapi.PlaceholderAPI;
import me.deecaad.core.MechanicsCore;
import me.deecaad.core.placeholder.PlaceholderData;
import me.deecaad.core.placeholder.PlaceholderHandler;
import me.deecaad.core.placeholder.PlaceholderRequestEvent;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.intellij.lang.annotations.RegExp;
import org.jetbrains.annotations.NotNull;

public class PlaceholderMessage {
    @RegExp
    public static final String TAG = "<([a-zA-Z_\\-]+)>";
    public static final Pattern TAG_PATTERN = Pattern.compile("<([a-zA-Z_\\-]+)>");
    private final String template;
    private final Set<String> presentPlaceholders;

    public PlaceholderMessage(@NotNull String template) {
        LinkedHashSet<String> presentPlaceholders = new LinkedHashSet<String>();
        Matcher matcher = TAG_PATTERN.matcher(template);
        while (matcher.find()) {
            String placeholderString = matcher.group(1).toLowerCase();
            PlaceholderHandler placeholderHandler = PlaceholderHandler.REGISTRY.get(placeholderString);
            if (placeholderHandler == null) continue;
            presentPlaceholders.add(placeholderString);
        }
        this.template = template;
        this.presentPlaceholders = Collections.unmodifiableSet(presentPlaceholders);
    }

    public String getTemplate() {
        return this.template;
    }

    public Set<String> getPresentPlaceholders() {
        return this.presentPlaceholders;
    }

    public void fillMap(PlaceholderData data) {
        for (String placeholder : this.presentPlaceholders) {
            PlaceholderHandler handler = PlaceholderHandler.REGISTRY.get(placeholder);
            data.placeholders().put(placeholder, handler == null ? null : handler.onRequest(data));
        }
    }

    public Component replaceAndDeserialize(PlaceholderData data) {
        boolean isAdvancedPlaceholders = MechanicsCore.getPlugin().getConfig().getBoolean("Advanced_Placeholders", false);
        boolean isPlaceholderApi = Bukkit.getPluginManager().isPluginEnabled("PlaceholderAPI");
        this.fillMap(data);
        PlaceholderRequestEvent event = new PlaceholderRequestEvent(data);
        Bukkit.getPluginManager().callEvent((Event)event);
        String message = this.template;
        if (!isAdvancedPlaceholders && isPlaceholderApi) {
            message = PlaceholderAPI.setPlaceholders((Player)data.player(), (String)message);
        }
        Map<String, String> placeholders = event.placeholders();
        TagResolver[] tagResolvers = new TagResolver[event.placeholders().size()];
        int i = 0;
        for (Map.Entry<String, String> entry : placeholders.entrySet()) {
            tagResolvers[i++] = Placeholder.parsed((String)entry.getKey(), (String)entry.getValue());
        }
        Component returnValue = MechanicsCore.getPlugin().message.deserialize(message, tagResolvers);
        if (isAdvancedPlaceholders && isPlaceholderApi) {
            message = (String)MechanicsCore.getPlugin().message.serialize(returnValue);
            message = PlaceholderAPI.setPlaceholders((Player)data.player(), (String)message);
            returnValue = MechanicsCore.getPlugin().message.deserialize((Object)message);
        }
        return returnValue;
    }
}

