/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.core.mechanics.targeters;

import java.util.Collections;
import java.util.Iterator;
import me.deecaad.core.MechanicsCore;
import me.deecaad.core.mechanics.CastData;
import me.deecaad.core.mechanics.targeters.WorldTargeter;
import org.bukkit.Bukkit;
import org.bukkit.entity.LivingEntity;

public class WorldPlayersTargeter
extends WorldTargeter {
    public WorldPlayersTargeter() {
    }

    public WorldPlayersTargeter(String worldName) {
        super(worldName);
    }

    @Override
    public String getKeyword() {
        return "WorldPlayers";
    }

    @Override
    public Iterator<CastData> getTargets0(final CastData cast) {
        if (this.getWorldCache() == null || this.getWorldName() == null) {
            this.setWorldCache(this.getWorldName() == null ? cast.getSource().getWorld() : Bukkit.getWorld((String)this.getWorldName()));
        }
        if (this.getWorldCache() == null) {
            MechanicsCore.debug.warn("There was an error getting the world for '" + this.getWorldName() + "'");
            return Collections.emptyIterator();
        }
        final Iterator entityIterator = this.getWorldCache().getPlayers().iterator();
        return new Iterator<CastData>(){

            @Override
            public boolean hasNext() {
                return entityIterator.hasNext();
            }

            @Override
            public CastData next() {
                cast.setTargetEntity((LivingEntity)entityIterator.next());
                return cast;
            }
        };
    }
}

