/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.core.mechanics.defaultmechanics;

import io.lumine.mythic.bukkit.MythicBukkit;
import java.util.ArrayList;
import java.util.Iterator;
import me.deecaad.core.file.JarSearcherExempt;
import me.deecaad.core.file.SerializeData;
import me.deecaad.core.file.SerializerException;
import me.deecaad.core.mechanics.CastData;
import me.deecaad.core.mechanics.conditions.Condition;
import me.deecaad.core.mechanics.defaultmechanics.Mechanic;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MythicSkillMechanic
extends Mechanic
implements JarSearcherExempt {
    private String skillName;
    private float power;

    public MythicSkillMechanic() {
    }

    public MythicSkillMechanic(String skillName, float power) {
        this.skillName = skillName;
        this.power = power;
    }

    @Override
    protected void handleTargetersAndConditions(CastData cast) {
        this.use0(cast);
    }

    @Override
    public String getKeyword() {
        return "MythicSkill";
    }

    @Override
    @Nullable
    public String getWikiLink() {
        return "https://cjcrafter.gitbook.io/mechanics/integrations/mythicmobs#mythic-skill-mechanic";
    }

    @Override
    protected void use0(CastData cast) {
        ArrayList<LivingEntity> eTargets = new ArrayList<LivingEntity>();
        ArrayList<Location> lTargets = new ArrayList<Location>();
        Iterator<CastData> it = this.targeter.getTargets(cast);
        block0: while (it.hasNext()) {
            CastData target = it.next();
            for (Condition condition : this.conditions) {
                if (condition.isAllowed(target)) continue;
                continue block0;
            }
            if (target.getTarget() != null) {
                eTargets.add(target.getTarget());
                continue;
            }
            lTargets.add(target.getTargetLocation().clone());
        }
        MythicBukkit.inst().getAPIHelper().castSkill((Entity)cast.getSource(), this.skillName, cast.getSourceLocation(), eTargets, lTargets, this.power);
    }

    @Override
    @NotNull
    public Mechanic serialize(@NotNull SerializeData data) throws SerializerException {
        String skill = (String)data.of("Skill").assertExists().assertType(String.class).get();
        float power = (float)data.of("Power").getDouble(1.0);
        return this.applyParentArgs(data, new MythicSkillMechanic(skill, power));
    }
}

