/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.core.mechanics.defaultmechanics;

import me.deecaad.core.MechanicsCore;
import me.deecaad.core.file.SerializeData;
import me.deecaad.core.file.SerializerException;
import me.deecaad.core.mechanics.CastData;
import me.deecaad.core.mechanics.defaultmechanics.Mechanic;
import me.deecaad.core.placeholder.PlaceholderMessage;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MessageMechanic
extends Mechanic {
    private PlaceholderMessage message;

    public MessageMechanic() {
    }

    public MessageMechanic(String message) {
        this.message = new PlaceholderMessage(message);
    }

    public String getMessage() {
        return this.message.getTemplate();
    }

    @Override
    public void use0(CastData cast) {
        LivingEntity livingEntity = cast.getTarget();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        Component chat = this.message.replaceAndDeserialize(cast);
        Audience audience = MechanicsCore.getPlugin().adventure.player(player);
        audience.sendMessage(chat);
    }

    @Override
    public String getKeyword() {
        return "Message";
    }

    @Override
    @Nullable
    public String getWikiLink() {
        return "https://cjcrafter.gitbook.io/mechanics/mechanics/message";
    }

    @Override
    @NotNull
    public Mechanic serialize(@NotNull SerializeData data) throws SerializerException {
        String message = data.of("Message").assertExists().getAdventure();
        return this.applyParentArgs(data, new MessageMechanic(message));
    }
}

