/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.core.mechanics.defaultmechanics;

import java.util.Iterator;
import java.util.List;
import me.deecaad.core.MechanicsCore;
import me.deecaad.core.file.InlineSerializer;
import me.deecaad.core.file.SerializeData;
import me.deecaad.core.file.SerializerException;
import me.deecaad.core.file.serializers.ChanceSerializer;
import me.deecaad.core.mechanics.CastData;
import me.deecaad.core.mechanics.conditions.Condition;
import me.deecaad.core.mechanics.targeters.Targeter;
import me.deecaad.core.utils.RandomUtil;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public abstract class Mechanic
implements InlineSerializer<Mechanic> {
    public Targeter targeter;
    public List<Condition> conditions;
    private int repeatAmount;
    private int repeatInterval;
    private int delayBeforePlay;
    private double chance;

    public Targeter getTargeter() {
        return this.targeter;
    }

    public List<Condition> getConditions() {
        return this.conditions;
    }

    public int getRepeatAmount() {
        return this.repeatAmount;
    }

    public int getRepeatInterval() {
        return this.repeatInterval;
    }

    public int getDelayBeforePlay() {
        return this.delayBeforePlay;
    }

    public double getChance() {
        return this.chance;
    }

    public void use(final CastData cast) {
        if (!RandomUtil.chance(this.chance)) {
            return;
        }
        if (this.repeatAmount == 1 && this.repeatInterval == 1 && this.delayBeforePlay == 0) {
            this.handleTargetersAndConditions(cast.clone());
            return;
        }
        int task = new BukkitRunnable(){
            int runs = 0;

            public void run() {
                if (this.runs++ >= Mechanic.this.repeatAmount) {
                    this.cancel();
                    return;
                }
                Mechanic.this.handleTargetersAndConditions(cast.clone());
            }
        }.runTaskTimer((Plugin)MechanicsCore.getPlugin(), (long)this.delayBeforePlay, (long)(this.repeatInterval - 1)).getTaskId();
        if (cast.getTaskIdConsumer() != null) {
            cast.getTaskIdConsumer().accept(task);
        }
    }

    protected void handleTargetersAndConditions(CastData cast) {
        Iterator<CastData> it = this.targeter.getTargets(cast);
        block0: while (it.hasNext()) {
            CastData target = it.next();
            for (Condition condition : this.conditions) {
                if (condition.isAllowed(target)) continue;
                continue block0;
            }
            this.use0(target);
        }
    }

    protected abstract void use0(CastData var1);

    public Mechanic applyParentArgs(SerializeData data, Mechanic mechanic) throws SerializerException {
        mechanic.repeatAmount = data.of("Repeat_Amount").getInt(1);
        mechanic.repeatInterval = data.of("Repeat_Interval").getInt(1);
        mechanic.delayBeforePlay = data.of("Delay_Before_Play").getInt(0);
        Double chance = data.of("Chance").serialize(new ChanceSerializer());
        mechanic.chance = chance == null ? 1.0 : chance;
        return mechanic;
    }
}

