/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.core.mechanics.defaultmechanics;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Supplier;
import me.deecaad.core.MechanicsCore;
import me.deecaad.core.compatibility.CompatibilityAPI;
import me.deecaad.core.compatibility.entity.FakeEntity;
import me.deecaad.core.file.InlineSerializer;
import me.deecaad.core.file.MapConfigLike;
import me.deecaad.core.file.SerializeData;
import me.deecaad.core.file.SerializerException;
import me.deecaad.core.file.SerializerTypeException;
import me.deecaad.core.file.serializers.ColorSerializer;
import me.deecaad.core.mechanics.CastData;
import me.deecaad.core.mechanics.Mechanics;
import me.deecaad.core.mechanics.PlayerEffectMechanic;
import me.deecaad.core.mechanics.conditions.Condition;
import me.deecaad.core.mechanics.defaultmechanics.Mechanic;
import me.deecaad.core.mechanics.targeters.Targeter;
import me.deecaad.core.mechanics.targeters.WorldTargeter;
import me.deecaad.core.utils.DistanceUtil;
import me.deecaad.core.utils.MinecraftVersions;
import org.bukkit.EntityEffect;
import org.bukkit.FireworkEffect;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FireworkMechanic
extends PlayerEffectMechanic {
    private static final EntityType FIREWORK_ENTITY = MinecraftVersions.TRAILS_AND_TAILS.get(5).isAtLeast() ? EntityType.FIREWORK_ROCKET : EntityType.valueOf((String)"FIREWORK");
    private ItemStack fireworkItem;
    private int flightTime;
    private Targeter viewers;
    private List<Condition> viewerConditions;

    public FireworkMechanic() {
    }

    public FireworkMechanic(ItemStack fireworkItem, int flightTime, Targeter viewers, List<Condition> viewerConditions) {
        this.fireworkItem = fireworkItem;
        this.flightTime = flightTime;
        this.viewers = viewers;
        this.viewerConditions = viewerConditions;
    }

    public ItemStack getFireworkItem() {
        return this.fireworkItem;
    }

    public int getFlightTime() {
        return this.flightTime;
    }

    public Targeter getViewers() {
        return this.viewers;
    }

    @Override
    public List<Condition> getViewerConditions() {
        return this.viewerConditions;
    }

    @Override
    public void use0(CastData cast) {
        List<Player> players;
        if (this.viewers == null) {
            players = DistanceUtil.getPlayersInRange(cast.getTargetLocation());
        } else {
            players = new LinkedList<Player>();
            CastData center = cast;
            if (cast.hasTargetLocation()) {
                center = center.clone();
                center.setTargetLocation((Supplier<Location>)null);
            }
            Iterator<CastData> it = this.viewers.getTargets(center);
            block0: while (it.hasNext()) {
                CastData target = it.next();
                LivingEntity livingEntity = target.getTarget();
                if (!(livingEntity instanceof Player)) continue;
                Player player = (Player)livingEntity;
                for (Condition condition : this.viewerConditions) {
                    if (condition.isAllowed(target)) continue;
                    continue block0;
                }
                players.add(player);
            }
        }
        if (players.isEmpty()) {
            return;
        }
        this.playFor(cast, players);
    }

    @Override
    public String getKeyword() {
        return "Firework";
    }

    @Override
    @Nullable
    public String getWikiLink() {
        return "https://cjcrafter.gitbook.io/mechanics/mechanics/firework";
    }

    @Override
    @NotNull
    public Mechanic serialize(@NotNull SerializeData data) throws SerializerException {
        ItemStack fireworkItem = new ItemStack(MinecraftVersions.UPDATE_AQUATIC.isAtLeast() ? Material.FIREWORK_ROCKET : Material.valueOf((String)"FIREWORK"));
        FireworkMeta meta = (FireworkMeta)fireworkItem.getItemMeta();
        List<FireworkEffect> effects = data.of("Effects").getImpliedList(new FireworkData()).stream().map(FireworkData::getEffect).toList();
        int flightTime = data.of("Flight_Time").getInt(0);
        meta.addEffects(effects);
        meta.setPower(flightTime);
        fireworkItem.setItemMeta((ItemMeta)meta);
        Targeter viewers = data.of("Viewers").getRegistry(Mechanics.TARGETERS, null);
        List<Condition> viewerConditions = data.of("Viewer_Conditions").getRegistryList(Mechanics.CONDITIONS);
        if (!viewerConditions.isEmpty() && viewers == null) {
            viewers = new WorldTargeter();
        }
        return this.applyParentArgs(data, new FireworkMechanic(fireworkItem, flightTime, viewers, viewerConditions));
    }

    @Override
    public void playFor(CastData cast, List<Player> viewers) {
        final FakeEntity fakeEntity = CompatibilityAPI.getCompatibility().getEntityCompatibility().generateFakeEntity(cast.getTargetLocation(), FIREWORK_ENTITY, this.fireworkItem);
        if (this.flightTime > 1) {
            fakeEntity.setMotion(0.001, 0.3, -0.001);
        }
        for (Player player : viewers) {
            fakeEntity.show(player);
        }
        if (this.flightTime <= 0) {
            fakeEntity.playEffect(EntityEffect.FIREWORK_EXPLODE);
            fakeEntity.remove();
            return;
        }
        new BukkitRunnable(){

            public void run() {
                fakeEntity.playEffect(EntityEffect.FIREWORK_EXPLODE);
                fakeEntity.remove();
            }
        }.runTaskLater((Plugin)MechanicsCore.getPlugin(), (long)this.flightTime);
    }

    @Override
    @Nullable
    public Targeter getViewerTargeter() {
        return this.viewers;
    }

    public static class FireworkData
    implements InlineSerializer<FireworkData> {
        private FireworkEffect effect;

        public FireworkData() {
        }

        public FireworkData(FireworkEffect effect) {
            this.effect = effect;
        }

        public FireworkEffect getEffect() {
            return this.effect;
        }

        @Override
        public String getKeyword() {
            return "Firework";
        }

        @Override
        @NotNull
        public FireworkData serialize(@NotNull SerializeData data) throws SerializerException {
            List<Object> fadeColors;
            List<Object> colors;
            boolean flicker;
            boolean trail;
            FireworkEffect.Type type;
            block7: {
                Object color;
                List temp;
                type = data.of("Shape").getEnum(FireworkEffect.Type.class, FireworkEffect.Type.BALL);
                trail = data.of("Trail").getBool(false);
                flicker = data.of("Flicker").getBool(false);
                colors = new ArrayList();
                fadeColors = new ArrayList();
                try {
                    temp = (List)data.of("Color").assertExists().assertType(List.class).get();
                    for (MapConfigLike.Holder holder : temp) {
                        colors.add(ColorSerializer.fromString(data.move("Color"), holder.value().toString()));
                    }
                }
                catch (SerializerTypeException ex) {
                    color = data.of("Color").serialize(new ColorSerializer());
                    if (color == null) {
                        throw data.exception("Color", "Could not determine 'color'", "Try using 'color=RED' or 'color=[RED, GREEN]'");
                    }
                    colors = List.of(((ColorSerializer)color).getColor());
                }
                try {
                    temp = data.of("Fade_Color").assertType(List.class).get(List.of());
                    for (MapConfigLike.Holder holder : temp) {
                        fadeColors.add(ColorSerializer.fromString(data.move("Fade_Color"), holder.value().toString()));
                    }
                }
                catch (SerializerTypeException ex) {
                    color = data.of("Fade_Color").serialize(new ColorSerializer());
                    if (color == null) break block7;
                    fadeColors = List.of(((ColorSerializer)color).getColor());
                }
            }
            FireworkEffect effect = FireworkEffect.builder().with(type).withColor(colors).trail(trail).flicker(flicker).withFade(fadeColors).build();
            return new FireworkData(effect);
        }
    }
}

