/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.core.mechanics.defaultmechanics;

import me.deecaad.core.MechanicsCore;
import me.deecaad.core.file.SerializeData;
import me.deecaad.core.file.SerializerException;
import me.deecaad.core.mechanics.CastData;
import me.deecaad.core.mechanics.defaultmechanics.Mechanic;
import org.bukkit.entity.LivingEntity;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DamageMechanic
extends Mechanic {
    public static final String METADATA_KEY = "mechanicscore-damagemechanic";
    private double damage;
    private boolean resetHitCooldown;
    private boolean requiresEvent;
    private boolean ignoreArmor;

    public DamageMechanic() {
    }

    public DamageMechanic(double damage, boolean ignoreArmor, boolean resetHitCooldown) {
        this.damage = damage;
        this.resetHitCooldown = resetHitCooldown;
        this.requiresEvent = ignoreArmor;
        this.ignoreArmor = ignoreArmor;
    }

    public double getDamage() {
        return this.damage;
    }

    public boolean isRequireEvent() {
        return this.requiresEvent;
    }

    public boolean isIgnoreArmor() {
        return this.ignoreArmor;
    }

    @Override
    public String getKeyword() {
        return "Damage";
    }

    @Override
    @Nullable
    public String getWikiLink() {
        return "https://cjcrafter.gitbook.io/mechanics/mechanics/damage";
    }

    @Override
    protected void use0(CastData cast) {
        if (cast.getTarget() == null) {
            return;
        }
        LivingEntity target = cast.getTarget();
        if (this.requiresEvent) {
            target.setMetadata(METADATA_KEY, (MetadataValue)new FixedMetadataValue((Plugin)MechanicsCore.getPlugin(), (Object)this));
        }
        cast.getTarget().damage(this.damage);
        if (this.resetHitCooldown) {
            cast.getTarget().setNoDamageTicks(0);
        }
    }

    @Override
    @NotNull
    public Mechanic serialize(@NotNull SerializeData data) throws SerializerException {
        double damage = data.of("Damage").getDouble(1.0);
        boolean ignoreArmor = data.of("Ignore_Armor").getBool(false);
        boolean resetHitCooldown = data.of("Reset_Cooldown").getBool(false);
        return this.applyParentArgs(data, new DamageMechanic(damage, ignoreArmor, resetHitCooldown));
    }
}

