/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.core.mechanics.defaultmechanics;

import me.deecaad.core.file.SerializeData;
import me.deecaad.core.file.SerializerException;
import me.deecaad.core.mechanics.CastData;
import me.deecaad.core.mechanics.defaultmechanics.Mechanic;
import me.deecaad.core.placeholder.PlaceholderMessage;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommandMechanic
extends Mechanic {
    private boolean console;
    private PlaceholderMessage command;

    public CommandMechanic() {
    }

    public CommandMechanic(boolean console, String command) {
        this.console = console;
        this.command = new PlaceholderMessage(command);
    }

    public boolean isConsole() {
        return this.console;
    }

    public String getCommand() {
        return this.command.getTemplate();
    }

    @Override
    public void use0(CastData cast) {
        Player player = cast.getTarget().getType() == EntityType.PLAYER ? (Player)cast.getTarget() : null;
        String command = LegacyComponentSerializer.legacySection().serialize(this.command.replaceAndDeserialize(cast));
        if (this.console) {
            Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)command);
        } else if (player != null) {
            player.performCommand(command);
        }
    }

    @Override
    public String getKeyword() {
        return "Command";
    }

    @Override
    @Nullable
    public String getWikiLink() {
        return "https://cjcrafter.gitbook.io/mechanics/mechanics/command";
    }

    @Override
    @NotNull
    public Mechanic serialize(@NotNull SerializeData data) throws SerializerException {
        boolean console = data.of("Console").getBool(false);
        String command = (String)data.of("Command").assertType(String.class).assertExists().get();
        return this.applyParentArgs(data, new CommandMechanic(console, command));
    }
}

