/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.core.mechanics.defaultmechanics;

import me.deecaad.core.MechanicsCore;
import me.deecaad.core.file.SerializeData;
import me.deecaad.core.file.SerializerException;
import me.deecaad.core.mechanics.CastData;
import me.deecaad.core.mechanics.defaultmechanics.Mechanic;
import me.deecaad.core.placeholder.PlaceholderMessage;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ActionBarMechanic
extends Mechanic {
    private PlaceholderMessage message;
    private int time;

    public ActionBarMechanic() {
    }

    public ActionBarMechanic(String message, int time) {
        this.message = new PlaceholderMessage(message);
        this.time = time;
    }

    public String getMessage() {
        return this.message.getTemplate();
    }

    public PlaceholderMessage getPlaceholderMessage() {
        return this.message;
    }

    public int getTime() {
        return this.time;
    }

    @Override
    public void use0(CastData cast) {
        LivingEntity livingEntity = cast.getTarget();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        final Component component = this.message.replaceAndDeserialize(cast);
        final Audience audience = MechanicsCore.getPlugin().adventure.player(player);
        audience.sendActionBar(component);
        if (this.time > 40) {
            new BukkitRunnable(){
                int ticker = 0;

                public void run() {
                    this.ticker += 40;
                    if (this.ticker >= ActionBarMechanic.this.time) {
                        this.cancel();
                        return;
                    }
                    audience.sendActionBar(component);
                }
            }.runTaskTimer((Plugin)MechanicsCore.getPlugin(), (long)(40 - this.time % 40), 40L);
        }
    }

    @Override
    public String getKeyword() {
        return "Action_Bar";
    }

    @Override
    @Nullable
    public String getWikiLink() {
        return "https://cjcrafter.gitbook.io/mechanics/mechanics/action-bar";
    }

    @Override
    @NotNull
    public Mechanic serialize(@NotNull SerializeData data) throws SerializerException {
        String message = data.of("Message").assertExists().getAdventure();
        int time = data.of("Time").assertRange(40, Integer.MAX_VALUE).getInt(40);
        return this.applyParentArgs(data, new ActionBarMechanic(message, time));
    }
}

