/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.core.mechanics.conditions;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import me.deecaad.core.file.MapConfigLike;
import me.deecaad.core.file.SerializeData;
import me.deecaad.core.file.SerializerEnumException;
import me.deecaad.core.file.SerializerException;
import me.deecaad.core.mechanics.CastData;
import me.deecaad.core.mechanics.conditions.Condition;
import me.deecaad.core.utils.EnumUtil;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OnGroundCondition
extends Condition {
    private Set<Material> blocks;

    public OnGroundCondition() {
    }

    public OnGroundCondition(Set<Material> blocks) {
        this.blocks = blocks;
    }

    @Override
    protected boolean isAllowed0(CastData cast) {
        if (cast.getTarget() == null) {
            return false;
        }
        Material material = cast.getTargetLocation().getBlock().getRelative(BlockFace.DOWN).getType();
        return cast.getTarget().isOnGround() && this.blocks.contains(material);
    }

    @Override
    public String getKeyword() {
        return "On_Ground";
    }

    @Override
    @Nullable
    public String getWikiLink() {
        return "https://cjcrafter.gitbook.io/mechanics/conditions/on-ground";
    }

    @Override
    @NotNull
    public Condition serialize(@NotNull SerializeData data) throws SerializerException {
        List materials = data.of("Blocks").assertType(List.class).get(List.of());
        HashSet<Material> blocks = new HashSet<Material>();
        for (MapConfigLike.Holder holder : materials) {
            String block = holder.value().toString();
            List<Material> temp = EnumUtil.parseEnums(Material.class, block);
            if (temp.isEmpty()) {
                throw new SerializerEnumException(this, Material.class, block, true, data.of("Blocks").getLocation());
            }
            blocks.addAll(temp);
        }
        return this.applyParentArgs(data, new OnGroundCondition(blocks));
    }
}

