/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.core.mechanics.conditions;

import io.lumine.mythic.api.adapters.AbstractPlayer;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.core.mobs.ActiveMob;
import java.util.Objects;
import java.util.Optional;
import me.deecaad.core.file.JarSearcherExempt;
import me.deecaad.core.file.SerializeData;
import me.deecaad.core.file.SerializerException;
import me.deecaad.core.mechanics.CastData;
import me.deecaad.core.mechanics.conditions.Condition;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MythicMobsFactionCondition
extends Condition
implements JarSearcherExempt {
    private String faction;

    public MythicMobsFactionCondition() {
    }

    public MythicMobsFactionCondition(String faction) {
        this.faction = faction;
    }

    @Override
    protected boolean isAllowed0(CastData cast) {
        LivingEntity target = cast.getTarget();
        if (target == null) {
            return false;
        }
        if (target instanceof Player) {
            Player player = (Player)target;
            AbstractPlayer abstractPlayer = BukkitAdapter.adapt((Player)player);
            Optional maybeFaction = MythicBukkit.inst().getPlayerManager().getFactionProvider().getFaction(abstractPlayer.asPlayer());
            return Objects.equals(maybeFaction.orElse(null), this.faction);
        }
        ActiveMob activeMob = MythicBukkit.inst().getMobManager().getMythicMobInstance((Entity)target);
        if (activeMob == null || !activeMob.hasFaction()) {
            return false;
        }
        return Objects.equals(activeMob.getFaction(), this.faction);
    }

    @Override
    public String getKeyword() {
        return "MythicMobsFaction";
    }

    @Override
    @Nullable
    public String getWikiLink() {
        return "https://cjcrafter.gitbook.io/mechanics/integrations/mythicmobs#mythic-mobs-faction-condition";
    }

    @Override
    @NotNull
    public Condition serialize(@NotNull SerializeData data) throws SerializerException {
        String faction = data.of("Faction").assertType(String.class).get(null);
        return this.applyParentArgs(data, new MythicMobsFactionCondition(faction));
    }
}

