/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.core.mechanics.conditions;

import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.core.mobs.ActiveMob;
import me.deecaad.core.file.JarSearcherExempt;
import me.deecaad.core.file.SerializeData;
import me.deecaad.core.file.SerializerException;
import me.deecaad.core.mechanics.CastData;
import me.deecaad.core.mechanics.conditions.Condition;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MythicMobsEntityCondition
extends Condition
implements JarSearcherExempt {
    private String name;

    public MythicMobsEntityCondition() {
    }

    public MythicMobsEntityCondition(String name) {
        this.name = name;
    }

    @Override
    public boolean isAllowed0(CastData cast) {
        if (cast.getTarget() == null) {
            return false;
        }
        ActiveMob mythicMob = MythicBukkit.inst().getMobManager().getActiveMob(cast.getTarget().getUniqueId()).orElse(null);
        return mythicMob != null && mythicMob.getName().equals(this.name);
    }

    @Override
    public String getKeyword() {
        return "MythicMobsEntity";
    }

    @Override
    @Nullable
    public String getWikiLink() {
        return "https://cjcrafter.gitbook.io/mechanics/integrations/mythicmobs#mythic-mobs-entity-condition";
    }

    @Override
    @NotNull
    public Condition serialize(@NotNull SerializeData data) throws SerializerException {
        String type = (String)data.of("Entity").assertExists().get();
        return this.applyParentArgs(data, new MythicMobsEntityCondition(type));
    }
}

