/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.core.mechanics.conditions;

import me.deecaad.core.file.SerializeData;
import me.deecaad.core.file.SerializerException;
import me.deecaad.core.mechanics.CastData;
import me.deecaad.core.mechanics.conditions.Condition;
import org.bukkit.entity.LivingEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HasPermissionCondition
extends Condition {
    private String permission;

    public HasPermissionCondition() {
    }

    public HasPermissionCondition(String permission) {
        this.permission = permission;
    }

    @Override
    protected boolean isAllowed0(CastData cast) {
        LivingEntity target = cast.getTarget();
        if (target == null) {
            return false;
        }
        return target.hasPermission(this.permission);
    }

    @Override
    public String getKeyword() {
        return "HasPermission";
    }

    @Override
    @Nullable
    public String getWikiLink() {
        return "https://cjcrafter.gitbook.io/mechanics/conditions/has-permission";
    }

    @Override
    @NotNull
    public Condition serialize(@NotNull SerializeData data) throws SerializerException {
        String permission = (String)data.of("Permission").assertExists().get();
        return this.applyParentArgs(data, new HasPermissionCondition(permission));
    }
}

