/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.core.mechanics;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import me.deecaad.core.MechanicsCore;
import me.deecaad.core.utils.Keyable;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Registry<T extends Keyable>
implements Keyable {
    private final String registryName;
    private final Map<String, T> registry;

    public Registry(@NotNull String registryName) {
        this.registryName = registryName;
        this.registry = new HashMap<String, T>();
    }

    @Override
    @NotNull
    public String getKey() {
        return this.registryName;
    }

    @Contract(value="_ -> this")
    @NotNull
    public Registry<T> add(@NotNull T item) {
        String key = Registry.toKey(item.getKey());
        Keyable existing = (Keyable)this.registry.get(key);
        if (existing != null) {
            MechanicsCore.debug.warn("Overriding '" + String.valueOf(existing) + "' with '" + String.valueOf(item) + "' in " + this.registryName + " registry");
        }
        this.registry.put(key, item);
        return this;
    }

    @Nullable
    public T get(@NotNull String key) {
        return (T)((Keyable)this.registry.get(Registry.toKey(key)));
    }

    @NotNull
    public Optional<T> getIfPresent(@NotNull String key) {
        return Optional.ofNullable(this.get(key));
    }

    @NotNull
    public Set<String> getOptions() {
        return this.registry.keySet();
    }

    public void clear() {
        this.registry.clear();
    }

    public static String toKey(String key) {
        return key.toLowerCase(Locale.ROOT).replace(" ", "").replace("_", "");
    }

    public static boolean matches(String key1, String key2) {
        return Registry.toKey(key1).equals(Registry.toKey(key2));
    }
}

