/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.core.mechanics;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Supplier;
import me.deecaad.core.file.JarSearcherExempt;
import me.deecaad.core.file.SerializeData;
import me.deecaad.core.file.SerializerException;
import me.deecaad.core.mechanics.CastData;
import me.deecaad.core.mechanics.PlayerEffectMechanic;
import me.deecaad.core.mechanics.conditions.Condition;
import me.deecaad.core.mechanics.defaultmechanics.Mechanic;
import me.deecaad.core.mechanics.targeters.Targeter;
import me.deecaad.core.mechanics.targeters.WorldTargeter;
import org.bukkit.Location;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public final class PlayerEffectMechanicList
extends Mechanic
implements JarSearcherExempt {
    private final List<PlayerEffectMechanic> mechanics = new LinkedList<PlayerEffectMechanic>();

    public void addMechanic(PlayerEffectMechanic mechanic) {
        WorldTargeter worldTargeter;
        Targeter targeter = mechanic.getViewerTargeter();
        if (!(targeter instanceof WorldTargeter) || !(worldTargeter = (WorldTargeter)targeter).isDefaultValues()) {
            throw new IllegalArgumentException("Cannot add " + String.valueOf(mechanic) + " due to modified targeter");
        }
        this.mechanics.add(mechanic);
    }

    public boolean isEmpty() {
        return this.mechanics.isEmpty();
    }

    @Override
    public void use(CastData cast) {
        List players = cast.getSource().getWorld().getPlayers();
        LinkedList<Player> cacheList = new LinkedList<Player>();
        for (PlayerEffectMechanic mechanic : this.mechanics) {
            Iterator<CastData> it = mechanic.targeter.getTargets(cast);
            block1: while (it.hasNext()) {
                CastData target = it.next();
                for (Condition condition : mechanic.conditions) {
                    if (condition.isAllowed(target)) continue;
                    continue block1;
                }
                LivingEntity targetEntity = target.getTarget();
                Supplier<Location> supplier = target.getTargetLocationSupplier();
                block3: for (Player player : players) {
                    target.setTargetEntity((LivingEntity)player);
                    for (Condition condition : mechanic.getViewerConditions()) {
                        if (condition.isAllowed(target)) continue;
                        continue block3;
                    }
                    cacheList.add(player);
                }
                target.setTargetEntity(targetEntity);
                target.setTargetLocation(supplier);
                mechanic.playFor(target, cacheList);
                cacheList.clear();
            }
        }
    }

    @Override
    protected void use0(CastData cast) {
        throw new UnsupportedOperationException("Cannot directly use a PlayerEffectMechanicList");
    }

    @Override
    @NotNull
    public Mechanic serialize(@NotNull SerializeData data) throws SerializerException {
        throw new UnsupportedOperationException("Cannot directly serialize a PlayerEffectMechanicList");
    }
}

