/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.core.mechanics;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import me.deecaad.core.MechanicsCore;
import me.deecaad.core.placeholder.PlaceholderData;
import me.deecaad.core.utils.LogLevel;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CastData
implements Cloneable,
PlaceholderData {
    private final LivingEntity source;
    private final String itemTitle;
    private final ItemStack itemStack;
    private LivingEntity targetEntity;
    private Supplier<Location> targetLocation;
    private Consumer<Integer> taskIdConsumer;
    @NotNull
    private final Map<String, String> tempPlaceholders;

    public CastData(@NotNull LivingEntity source, @Nullable String itemTitle, @Nullable ItemStack itemStack) {
        this.source = source;
        this.itemTitle = itemTitle;
        this.itemStack = itemStack;
        this.tempPlaceholders = new HashMap<String, String>();
        this.addDefaultPlaceholders();
    }

    public CastData(@NotNull LivingEntity source, @Nullable String itemTitle, @Nullable ItemStack itemStack, @NotNull Map<String, String> tempPlaceholders) {
        this.source = source;
        this.itemTitle = itemTitle;
        this.itemStack = itemStack;
        this.tempPlaceholders = tempPlaceholders;
        this.addDefaultPlaceholders();
    }

    public CastData(@NotNull LivingEntity source, @Nullable String itemTitle, @Nullable ItemStack itemStack, @Nullable Consumer<Integer> taskIdConsumer) {
        this.source = source;
        this.itemTitle = itemTitle;
        this.itemStack = itemStack;
        this.taskIdConsumer = taskIdConsumer;
        this.tempPlaceholders = new HashMap<String, String>();
        this.addDefaultPlaceholders();
    }

    private void addDefaultPlaceholders() {
        Location location = this.getSourceLocation();
        this.tempPlaceholders.put("source_name", this.getName(this.source));
        this.tempPlaceholders.put("source_x", String.valueOf(location.getX()));
        this.tempPlaceholders.put("source_y", String.valueOf(location.getY()));
        this.tempPlaceholders.put("source_z", String.valueOf(location.getZ()));
    }

    private String getName(LivingEntity entity) {
        TextComponent component = LegacyComponentSerializer.legacySection().deserialize(entity.getName());
        return (String)MechanicsCore.getPlugin().message.serialize((Component)component);
    }

    @NotNull
    public LivingEntity getSource() {
        return this.source;
    }

    @NotNull
    public Location getSourceLocation() {
        return this.source.getLocation();
    }

    @NotNull
    public World getSourceWorld() {
        return this.source.getWorld();
    }

    @Nullable
    public LivingEntity getTarget() {
        return this.targetEntity;
    }

    @Nullable
    public World getTargetWorld() {
        if (this.targetEntity != null) {
            return this.targetEntity.getWorld();
        }
        if (this.targetLocation != null) {
            return this.targetLocation.get().getWorld();
        }
        return null;
    }

    public void setTargetEntity(@NotNull LivingEntity targetEntity) {
        Location location = targetEntity.getLocation();
        this.tempPlaceholders.put("target_name", this.getName(targetEntity));
        this.tempPlaceholders.put("target_x", String.valueOf(location.getX()));
        this.tempPlaceholders.put("target_y", String.valueOf(location.getY()));
        this.tempPlaceholders.put("target_z", String.valueOf(location.getZ()));
        this.targetEntity = targetEntity;
    }

    public boolean hasTargetLocation() {
        return this.targetLocation != null;
    }

    @Nullable
    public Location getTargetLocation() {
        if (this.targetLocation == null && this.targetEntity == null) {
            MechanicsCore.debug.log(LogLevel.WARN, "Not targeting either entity nor location", new Throwable());
        }
        return this.targetLocation != null ? this.targetLocation.get() : this.targetEntity.getLocation();
    }

    @NotNull
    public Supplier<Location> getTargetLocationSupplier() {
        return this.targetLocation;
    }

    public void setTargetLocation(@NotNull Location targetLocation) {
        this.tempPlaceholders.put("target_x", String.valueOf(targetLocation.getX()));
        this.tempPlaceholders.put("target_y", String.valueOf(targetLocation.getY()));
        this.tempPlaceholders.put("target_z", String.valueOf(targetLocation.getZ()));
        this.targetLocation = () -> targetLocation;
    }

    public void setTargetLocation(@Nullable Supplier<Location> targetLocation) {
        if (targetLocation != null) {
            Location location = targetLocation.get();
            this.tempPlaceholders.put("target_x", String.valueOf(location.getX()));
            this.tempPlaceholders.put("target_y", String.valueOf(location.getY()));
            this.tempPlaceholders.put("target_z", String.valueOf(location.getZ()));
        }
        this.targetLocation = targetLocation;
    }

    @Nullable
    public Consumer<Integer> getTaskIdConsumer() {
        return this.taskIdConsumer;
    }

    public CastData clone() {
        try {
            return (CastData)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    @Nullable
    public Player player() {
        LivingEntity livingEntity = this.source;
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            return player;
        }
        return null;
    }

    @Override
    @Nullable
    public ItemStack item() {
        return this.itemStack;
    }

    @Override
    @Nullable
    public String itemTitle() {
        return this.itemTitle;
    }

    @Override
    @NotNull
    public Map<String, String> placeholders() {
        return this.tempPlaceholders;
    }
}

