/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.core.file.serializers;

import java.util.List;
import java.util.function.Function;
import me.deecaad.core.file.SerializeData;
import me.deecaad.core.file.Serializer;
import me.deecaad.core.file.SerializerException;
import me.deecaad.core.file.SerializerTypeException;
import me.deecaad.core.utils.EntityTransform;
import me.deecaad.core.utils.EnumUtil;
import me.deecaad.core.utils.Quaternion;
import me.deecaad.core.utils.RandomUtil;
import me.deecaad.core.utils.StringUtil;
import me.deecaad.core.utils.Transform;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;

public class VectorSerializer
implements Serializer<VectorSerializer> {
    private static final Vector UP = new Vector(0, 1, 0);
    private double randomLength;
    private Direction direction;
    private boolean relative;
    private Vector raw;

    public VectorSerializer() {
    }

    public VectorSerializer(double randomLength, Direction direction, boolean relative, Vector raw) {
        this.randomLength = randomLength;
        this.direction = direction;
        this.relative = relative;
        this.raw = raw;
    }

    public boolean isRelative() {
        return this.relative;
    }

    public Vector getVector(LivingEntity entity) {
        if (this.randomLength >= 0.0) {
            return RandomUtil.onUnitSphere().multiply(this.randomLength);
        }
        if (this.direction != null) {
            return this.direction.getRelative(entity == null ? null : entity.getLocation().getDirection());
        }
        if (this.raw == null) {
            throw new IllegalStateException("Impossible");
        }
        if (this.relative && entity != null) {
            return new EntityTransform((Entity)entity).getLocalRotation().multiply(this.raw);
        }
        return this.raw;
    }

    public Vector getVector(Vector view) {
        if (this.randomLength >= 0.0) {
            return RandomUtil.onUnitSphere().multiply(this.randomLength);
        }
        if (this.direction != null) {
            return this.direction.getRelative(view);
        }
        if (this.raw == null) {
            throw new IllegalStateException("Impossible");
        }
        if (this.relative && view != null) {
            Vector localUp = UP.equals((Object)view) ? new Vector(-1, 0, 0) : UP;
            Quaternion quaternion = Quaternion.lookAt(view, localUp);
            return quaternion.multiply(this.raw);
        }
        return this.raw;
    }

    @Override
    @NotNull
    public VectorSerializer serialize(@NotNull SerializeData data) throws SerializerException {
        String input = data.of().assertExists().get().toString().trim();
        if ("0".equals(input)) {
            return VectorSerializer.from(new Vector());
        }
        double randomLength = -1.0;
        Direction direction = EnumUtil.getIfPresent(Direction.class, input).orElse(null);
        Vector raw = null;
        boolean relative = false;
        if (direction == null) {
            List<String> split;
            if (input.startsWith("r")) {
                try {
                    randomLength = Double.parseDouble(input.substring(1));
                }
                catch (NumberFormatException ex) {
                    throw new SerializerTypeException(this, Number.class, String.class, (Object)input, data.of().getLocation());
                }
            }
            if (relative = input.startsWith("~")) {
                input = input.substring(1);
            }
            if ((split = StringUtil.split(input)).size() != 3) {
                throw data.exception(null, "Expected 3 numbers in left~up~forward format, instead got '" + split.size() + "'", SerializerException.forValue(input));
            }
            try {
                double x = Double.parseDouble(split.get(0));
                double y = Double.parseDouble(split.get(1));
                double z = Double.parseDouble(split.get(2));
                raw = new Vector(x, y, z);
            }
            catch (NumberFormatException ex) {
                throw new SerializerTypeException(this, Number.class, String.class, (Object)input, data.of().getLocation());
            }
        }
        return new VectorSerializer(randomLength, direction, relative, raw);
    }

    public static VectorSerializer from(final Vector vector) {
        return new VectorSerializer(){

            @Override
            public Vector getVector(LivingEntity entity) {
                return vector;
            }

            @Override
            public Vector getVector(Vector relative) {
                return vector;
            }
        };
    }

    public static enum Direction {
        UP(Transform::getUp, 0.0, 1.0, 0.0),
        DOWN(t -> t.getUp().multiply(-1.0), 0.0, -1.0, 0.0),
        RIGHT(Transform::getRight, 1.0, 0.0, 0.0),
        LEFT(t -> t.getRight().multiply(-1.0), -1.0, 0.0, 0.0),
        FORWARD(Transform::getForward, 0.0, 0.0, 1.0),
        BACKWARD(t -> t.getForward().multiply(-1.0), 0.0, 0.0, -1.0);

        private final Function<Transform, Vector> function;
        private final Vector raw;

        private Direction(Function<Transform, Vector> function, double x, double y, double z) {
            this.function = function;
            this.raw = new Vector(x, y, z);
        }

        public Vector getRelative(LivingEntity livingEntity) {
            if (livingEntity == null) {
                return this.raw.clone();
            }
            EntityTransform transform = new EntityTransform((Entity)livingEntity);
            return this.function.apply(transform);
        }

        public Vector getRelative(Vector relative) {
            if (relative == null) {
                return this.raw.clone();
            }
            Transform transform = new Transform();
            transform.setLocalRotation(Quaternion.lookAt(relative, UP));
            return this.function.apply(transform);
        }
    }
}

