/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.core.file.serializers;

import com.cryptomorin.xseries.XMaterial;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import me.deecaad.core.MechanicsCore;
import me.deecaad.core.compatibility.CompatibilityAPI;
import me.deecaad.core.compatibility.nbt.NBTCompatibility;
import me.deecaad.core.file.SerializeData;
import me.deecaad.core.file.Serializer;
import me.deecaad.core.file.SerializerEnumException;
import me.deecaad.core.file.SerializerException;
import me.deecaad.core.file.SerializerOptionsException;
import me.deecaad.core.file.SerializerRangeException;
import me.deecaad.core.file.SerializerTypeException;
import me.deecaad.core.file.serializers.ColorSerializer;
import me.deecaad.core.utils.AdventureUtil;
import me.deecaad.core.utils.AttributeType;
import me.deecaad.core.utils.EnumUtil;
import me.deecaad.core.utils.MinecraftVersions;
import me.deecaad.core.utils.ReflectionUtil;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.FireworkEffect;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Levelled;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.meta.ArmorMeta;
import org.bukkit.inventory.meta.BlockDataMeta;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.inventory.meta.trim.ArmorTrim;
import org.bukkit.inventory.meta.trim.TrimMaterial;
import org.bukkit.inventory.meta.trim.TrimPattern;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class ItemSerializer
implements Serializer<ItemStack> {
    public static final Map<String, Supplier<ItemStack>> ITEM_REGISTRY = new HashMap<String, Supplier<ItemStack>>();
    private static Method spigotMethod;
    private static Method setUnbreakable;
    private static final Field ingredientsField;

    @Override
    @NotNull
    public ItemStack serialize(@NotNull SerializeData data) throws SerializerException {
        return this.serializeWithTags(data, Collections.emptyMap());
    }

    public ItemStack serializeWithTags(@NotNull SerializeData data, @NotNull Map<String, Object> tags) throws SerializerException {
        if (data.key == null) {
            ItemStack itemStack = this.serializeWithoutRecipe(data);
            this.applyTags(itemStack, tags);
            itemStack = this.serializeRecipe(data, itemStack);
            return itemStack;
        }
        ItemStack inline = this.attemptInline(data);
        if (inline != null) {
            this.applyTags(inline, tags);
            return inline;
        }
        ItemStack itemStack = this.serializeWithoutRecipe(data);
        this.applyTags(itemStack, tags);
        itemStack = this.serializeRecipe(data, itemStack);
        return itemStack;
    }

    public void applyTags(@NotNull ItemStack item, @NotNull Map<String, Object> tags) {
        NBTCompatibility nbt = CompatibilityAPI.getNBTCompatibility();
        for (Map.Entry<String, Object> entry : tags.entrySet()) {
            String[] split = entry.getKey().split(":");
            String plugin = split[0];
            String tag = split[1];
            Object object = entry.getValue();
            if (object instanceof String) {
                String string = (String)object;
                nbt.setString(item, plugin, tag, string);
                continue;
            }
            object = entry.getValue();
            if (object instanceof Double) {
                Double num = (Double)object;
                nbt.setDouble(item, plugin, tag, num);
                continue;
            }
            object = entry.getValue();
            if (object instanceof Integer) {
                Integer num = (Integer)object;
                nbt.setInt(item, plugin, tag, num);
                continue;
            }
            object = entry.getValue();
            if (object instanceof int[]) {
                int[] arr = (int[])object;
                nbt.setArray(item, plugin, tag, arr);
                continue;
            }
            object = entry.getValue();
            if (object instanceof String[]) {
                String[] arr = (String[])object;
                nbt.setStringArray(item, plugin, tag, arr);
                continue;
            }
            throw new IllegalArgumentException("Unrecognized type " + String.valueOf(entry.getValue()) + " when setting custom tags");
        }
    }

    public ItemStack attemptInline(@NotNull SerializeData data) throws SerializerException {
        try {
            String registry = (String)data.of().assertType(String.class).assertExists().get();
            if (ITEM_REGISTRY.containsKey(registry)) {
                return ITEM_REGISTRY.get(registry).get();
            }
            XMaterial type = data.of().assertExists().getMaterial(null);
            if (type != null) {
                return type.parseItem();
            }
        }
        catch (SerializerTypeException registry) {
        }
        catch (SerializerEnumException ex) {
            Set<String> options = ex.getOptions();
            options.addAll(ITEM_REGISTRY.keySet());
            throw new SerializerOptionsException(ex.getSerializerName(), "Material", options, ex.getActual(), data.of().getLocation()).addMessage("https://github.com/WeaponMechanics/MechanicsMain/wiki/References#materials");
        }
        return null;
    }

    public ItemStack serializeWithoutRecipe(@NotNull SerializeData data) throws SerializerException {
        ItemMeta meta22;
        String string;
        List<String[]> enchantments;
        boolean hideFlags;
        short durability;
        List lore;
        XMaterial type = data.of("Type").assertExists().getMaterial(null);
        ItemStack itemStack = type.parseItem();
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (itemMeta == null) {
            throw data.exception("Type", "Did you use air as a material? This is not allowed!", SerializerException.forValue(type));
        }
        String name = data.of("Name").getAdventure(null);
        if (name != null) {
            Component component = MechanicsCore.getPlugin().message.deserialize((Object)("<!italic>" + name));
            AdventureUtil.setName(itemMeta, component);
        }
        if ((lore = (List)data.of("Lore").assertType(List.class).get(null)) != null) {
            AdventureUtil.setLoreUnparsed(itemMeta, lore);
        }
        if ((durability = (short)data.of("Durability").assertPositive().getInt(-99)) != -99) {
            if (MinecraftVersions.UPDATE_AQUATIC.isAtLeast()) {
                ((Damageable)itemMeta).setDamage((int)durability);
            } else {
                itemStack.setDurability(durability);
            }
        }
        boolean unbreakable = data.of("Unbreakable").getBool(false);
        itemMeta.setUnbreakable(unbreakable);
        if (data.has("Custom_Model_Data") && MinecraftVersions.VILLAGE_AND_PILLAGE.isAtLeast()) {
            itemMeta.setCustomModelData(Integer.valueOf(data.of("Custom_Model_Data").assertExists().getInt()));
        }
        if (hideFlags = data.of("Hide_Flags").getBool(false)) {
            itemMeta.addItemFlags(ItemFlag.values());
        }
        if ((enchantments = data.ofList("Enchantments").addArgument(Enchantment.class, true, true).addArgument(Integer.TYPE, true).assertList().get()) != null) {
            for (String[] stringArray : enchantments) {
                Enchantment enchant = MinecraftVersions.UPDATE_AQUATIC.isAtLeast() ? Enchantment.getByKey((NamespacedKey)NamespacedKey.minecraft((String)stringArray[0].trim().toLowerCase(Locale.ROOT))) : Enchantment.getByName((String)stringArray[0].trim().toLowerCase(Locale.ROOT));
                if (enchant == null) {
                    throw new SerializerOptionsException("Item", "Enchantment", (Iterable<String>)Arrays.stream(Enchantment.values()).map(ench -> MinecraftVersions.UPDATE_AQUATIC.isAtLeast() ? ench.getKey().getKey() : ench.getName()).collect(Collectors.toList()), stringArray[0], data.of("Enchantments").getLocation());
                }
                int enchantmentLevel = Integer.parseInt(stringArray[1]);
                itemMeta.addEnchant(enchant, enchantmentLevel - 1, true);
            }
        }
        itemStack.setItemMeta(itemMeta);
        data.ofList("Tags").addArgument(String.class, true).addArgument(Integer.TYPE, true).assertList().stream().forEach(split -> CompatibilityAPI.getNBTCompatibility().setInt(itemStack, "Custom", split[0], Integer.parseInt(split[1])));
        List<String[]> attributes = data.ofList("Attributes").addArgument(AttributeType.class, true).addArgument(Double.TYPE, true).addArgument(NBTCompatibility.AttributeSlot.class, false).assertList().get();
        if (attributes != null) {
            for (String[] split3 : attributes) {
                AttributeType attribute = EnumUtil.parseEnums(AttributeType.class, split3[0]).get(0);
                NBTCompatibility.AttributeSlot slot = split3.length > 2 ? EnumUtil.parseEnums(NBTCompatibility.AttributeSlot.class, split3[2]).get(0) : null;
                double amount = Double.parseDouble(split3[1]);
                CompatibilityAPI.getNBTCompatibility().setAttribute(itemStack, attribute, slot, amount);
            }
        }
        if ((string = (String)data.of("Skull_Owning_Player").assertType(String.class).get(null)) != null) {
            try {
                UUID uuid;
                int splitIndex = string.indexOf(" ");
                String id = splitIndex == -1 ? string : string.substring(0, splitIndex);
                String url = splitIndex == -1 ? null : string.substring(splitIndex + 1);
                SkullMeta skullMeta = (SkullMeta)itemStack.getItemMeta();
                try {
                    uuid = UUID.fromString(id);
                }
                catch (IllegalArgumentException e) {
                    uuid = null;
                }
                if (uuid != null && url != null) {
                    GameProfile dummy = new GameProfile(uuid, "ArmorMechanicsSkull");
                    byte[] byArray = Base64.getEncoder().encode(String.format("{textures:{SKIN:{url:\"%s\"}}}", url).getBytes());
                    dummy.getProperties().put((Object)"textures", (Object)new Property("textures", new String(byArray)));
                    Field field = ReflectionUtil.getField(skullMeta.getClass(), GameProfile.class);
                    ReflectionUtil.setField(field, skullMeta, dummy);
                } else if (uuid != null) {
                    skullMeta.setOwningPlayer(Bukkit.getServer().getOfflinePlayer(uuid));
                } else {
                    skullMeta.setOwner(string);
                }
                itemStack.setItemMeta((ItemMeta)skullMeta);
            }
            catch (ClassCastException e) {
                throw data.exception("Skull_Owning_Player", "Tried to use Skulls when the item wasn't a player head!", SerializerException.forValue(type));
            }
        }
        if (data.has("Potion_Color")) {
            try {
                Color color = data.of("Potion_Color").assertExists().serialize(new ColorSerializer()).getColor();
                PotionMeta potionMeta = (PotionMeta)itemStack.getItemMeta();
                potionMeta.setColor(color);
                itemStack.setItemMeta((ItemMeta)potionMeta);
            }
            catch (ClassCastException e) {
                throw data.exception("Potion_Color", "Tried to use Potion Color when the item wasn't a potion!", SerializerException.forValue(type));
            }
        }
        if (data.has("Leather_Color")) {
            try {
                Color color = data.of("Leather_Color").assertExists().serialize(new ColorSerializer()).getColor();
                LeatherArmorMeta meta22 = (LeatherArmorMeta)itemStack.getItemMeta();
                meta22.setColor(color);
                itemStack.setItemMeta((ItemMeta)meta22);
            }
            catch (ClassCastException e) {
                throw data.exception("Leather_Color", "Tried to use Leather Color when the item wasn't leather armor!", SerializerException.forValue(type));
            }
        }
        if (MinecraftVersions.TRAILS_AND_TAILS.isAtLeast() && (meta22 = itemStack.getItemMeta()) instanceof ArmorMeta) {
            ArmorMeta armor = (ArmorMeta)meta22;
            boolean hasOneOfPatternOrMaterial = data.has("Trim_Pattern") || data.has("Trim_Material");
            TrimPattern pattern = data.of("Trim_Pattern").assertExists(hasOneOfPatternOrMaterial).getKeyed(Registry.TRIM_PATTERN, null);
            TrimMaterial material = data.of("Trim_Material").assertExists(hasOneOfPatternOrMaterial).getKeyed(Registry.TRIM_MATERIAL, null);
            if (pattern != null && material != null) {
                armor.setTrim(new ArmorTrim(material, pattern));
                itemStack.setItemMeta((ItemMeta)armor);
            }
        }
        if (data.has("Firework")) {
            try {
                List<String[]> list = data.ofList("Firework.Effects").addArgument(FireworkEffect.Type.class, true).addArgument(ColorSerializer.class, true, true).addArgument(Boolean.TYPE, false).addArgument(Boolean.TYPE, false).addArgument(ColorSerializer.class, false).assertExists().assertList().get();
                FireworkMeta meta3 = (FireworkMeta)itemMeta;
                meta3.setPower(data.of("Firework.Power").assertPositive().getInt(1));
                for (String[] split4 : list) {
                    String[] stringArray;
                    String[] colors;
                    FireworkEffect.Builder builder = FireworkEffect.builder();
                    builder.with(FireworkEffect.Type.valueOf((String)split4[0]));
                    for (String color : colors = split4[1].split(", ?")) {
                        builder.withColor(ColorSerializer.fromString(data.move("Firework.Effects"), color));
                    }
                    builder.trail(split4.length > 2 && split4[2].equalsIgnoreCase("true"));
                    builder.flicker(split4.length > 3 && split4[3].equalsIgnoreCase("true"));
                    for (String color : stringArray = split4.length > 4 ? split4[4].split(", ?") : new String[]{}) {
                        builder.withFade(ColorSerializer.fromString(data.move("Firework.Effects"), color));
                    }
                    meta3.addEffect(builder.build());
                }
                itemStack.setItemMeta((ItemMeta)meta3);
            }
            catch (ClassCastException ex) {
                throw data.exception("Firework", "Tried to use Firework when the item wasn't a firework rocket!", SerializerException.forValue(type));
            }
        }
        if (data.has("Light_Level")) {
            if (!MinecraftVersions.CAVES_AND_CLIFFS_1.isAtLeast()) {
                throw data.exception("Light_Level", "Tried to use light level before MC 1.17!", "The light block was added in Minecraft version 1.17!");
            }
            try {
                BlockDataMeta meta4 = (BlockDataMeta)itemStack.getItemMeta();
                Levelled levelled = (Levelled)meta4.getBlockData(Material.LIGHT);
                int level = data.of("Light_Level").assertRange(0, levelled.getMaximumLevel()).getInt(0);
                levelled.setLevel(level);
                meta4.setBlockData((BlockData)levelled);
                itemStack.setItemMeta((ItemMeta)meta4);
            }
            catch (ClassCastException ex) {
                throw data.exception("Light_Level", "Tried to use the Light_Level option on a non 'LIGHT' block");
            }
        }
        if (data.of("Deny_Use_In_Crafting").getBool(false)) {
            CompatibilityAPI.getNBTCompatibility().setInt(itemStack, "MechanicsCore", "deny-crafting", 1);
        }
        return itemStack;
    }

    public ItemStack serializeRecipe(SerializeData data, ItemStack itemStack) throws SerializerException {
        block13: {
            Object str;
            if (!data.has("Recipe")) {
                return itemStack;
            }
            int resultAmount = data.of("Recipe.Output_Amount").assertRange(1, 64).getInt(1);
            ItemStack result = itemStack.clone();
            result.setAmount(resultAmount);
            ShapedRecipe recipe = new ShapedRecipe(new NamespacedKey((Plugin)MechanicsCore.getPlugin(), data.key), result);
            if (MinecraftVersions.NETHER_UPDATE.isAtLeast() && Bukkit.getRecipe((NamespacedKey)recipe.getKey()) != null) {
                return itemStack;
            }
            List shape = (List)data.of("Recipe.Shape").assertExists().assertType(List.class).get();
            String[] shapeArr = (String[])shape.stream().map(Object::toString).toArray(String[]::new);
            if (shape.size() < 1 || shape.size() > 3) {
                throw new SerializerRangeException((Serializer<?>)this, 1, shape.size(), 3, data.of("Recipe.Shape").getLocation());
            }
            HashSet<Character> ingredientChars = new HashSet<Character>();
            for (int i = 0; i < shapeArr.length; ++i) {
                str = shapeArr[i];
                if (((String)str).length() > 3) {
                    str = ((String)str).trim();
                    shapeArr[i] = str;
                }
                if (((String)str).length() < 1 || ((String)str).length() > 3) {
                    throw new SerializerRangeException((Serializer<?>)this, 1, shape.size(), 3, data.of("Recipe.Shape").getLocation());
                }
                for (char c : ((String)str).toCharArray()) {
                    ingredientChars.add(Character.valueOf(c));
                }
            }
            try {
                recipe.shape(shapeArr);
            }
            catch (Throwable ex) {
                throw data.exception("Recipe.Shape", "Recipe Shape was formatted incorrectly", ex.getMessage(), SerializerException.forValue(shape));
            }
            HashMap<Character, Object> ingredients = new HashMap<Character, Object>();
            data.of("Recipe.Ingredients").assertExists().assertType(ConfigurationSection.class);
            str = ingredientChars.iterator();
            while (str.hasNext()) {
                char c = ((Character)str.next()).charValue();
                if (c == ' ') continue;
                ItemStack item = data.of("Recipe.Ingredients." + c).assertExists().serialize(new ItemSerializer());
                if (MinecraftVersions.UPDATE_AQUATIC.isAtLeast()) {
                    ingredients.put(Character.valueOf(c), new RecipeChoice.ExactChoice(item));
                    continue;
                }
                ingredients.put(Character.valueOf(c), item);
            }
            ReflectionUtil.setField(ingredientsField, recipe, ingredients);
            try {
                Bukkit.addRecipe((Recipe)recipe);
            }
            catch (IllegalStateException ex) {
                if (ex.getMessage().startsWith("Duplicate recipe ignored with ID mechanicscore:")) break block13;
                throw ex;
            }
        }
        return itemStack;
    }

    private void setupUnbreakable() {
        if (spigotMethod == null) {
            try {
                spigotMethod = ReflectionUtil.getMethod(Class.forName("org.bukkit.inventory.meta.ItemMeta"), "spigot", new Class[0]);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        if (setUnbreakable == null) {
            try {
                setUnbreakable = ReflectionUtil.getMethod(Class.forName("org.bukkit.inventory.meta.ItemMeta$Spigot"), "setUnbreakable", Boolean.TYPE);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    static {
        ingredientsField = ReflectionUtil.getField(ShapedRecipe.class, "ingredients");
    }
}

