/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.core.file;

import java.util.NoSuchElementException;
import java.util.function.Function;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.jetbrains.annotations.NotNull;

public class TaskChain {
    private final Plugin plugin;
    private final ChainQueue queue;
    private boolean running;
    private final Object lock = new Object();

    public TaskChain(Plugin plugin) {
        this.plugin = plugin;
        this.queue = new ChainQueue();
    }

    public TaskChain thenRunSync(@NotNull Function<Object, Object> function) {
        if (function == null) {
            throw new IllegalArgumentException("Function cannot be null");
        }
        Task task = new Task(function, false);
        this.run(task);
        return this;
    }

    public TaskChain thenRunAsync(@NotNull Function<Object, Object> function) {
        if (function == null) {
            throw new IllegalArgumentException("Function cannot be null");
        }
        Task task = new Task(function, true);
        this.run(task);
        return this;
    }

    public TaskChain thenRunSync(@NotNull Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException("Function cannot be null");
        }
        Task task = new Task(ignore -> {
            runnable.run();
            return null;
        }, false);
        this.run(task);
        return this;
    }

    public TaskChain thenRunAsync(@NotNull Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException("Function cannot be null");
        }
        Task task = new Task(ignore -> {
            runnable.run();
            return null;
        }, true);
        this.run(task);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run(Task task) {
        Object object = this.lock;
        synchronized (object) {
            this.queue.push(task);
            if (!this.running) {
                this.queue.run();
                this.running = true;
            }
        }
    }

    private class ChainQueue {
        private Task head;
        private Task tail;
        private Object callback;

        ChainQueue() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void push(Task task) {
            Object object = TaskChain.this.lock;
            synchronized (object) {
                if (this.head == null) {
                    this.head = this.tail = task;
                    return;
                }
                this.tail = this.tail.next = task;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void pop() {
            Object object = TaskChain.this.lock;
            synchronized (object) {
                if (this.head == null) {
                    throw new NoSuchElementException();
                }
                this.head = this.head.next;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void run() {
            Object object = TaskChain.this.lock;
            synchronized (object) {
                if (this.head == null) {
                    throw new NoSuchElementException();
                }
                Object temp = this.callback;
                this.callback = null;
                this.head.run(TaskChain.this.plugin, temp);
            }
        }
    }

    private class Task {
        private final Function<Object, Object> function;
        private final boolean async;
        private Task next;

        public Task(Function<Object, Object> function, boolean async) {
            this.function = function;
            this.async = async;
        }

        public void run(final Plugin plugin, final Object callback) {
            BukkitRunnable bukkitTask = new BukkitRunnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    Object nextCallBack = Task.this.function.apply(callback);
                    Object object = TaskChain.this.lock;
                    synchronized (object) {
                        TaskChain.this.queue.pop();
                        if (Task.this.next != null) {
                            Task.this.next.run(plugin, nextCallBack);
                        } else {
                            TaskChain.this.queue.callback = callback;
                            TaskChain.this.running = false;
                        }
                    }
                }
            };
            if (this.async) {
                bukkitTask.runTaskAsynchronously(plugin);
            } else {
                bukkitTask.runTask(plugin);
            }
        }
    }
}

