/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.core.file;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.JarFile;
import me.deecaad.core.MechanicsCore;
import me.deecaad.core.file.InlineSerializer;
import me.deecaad.core.file.JarSearcher;
import me.deecaad.core.file.Serializer;
import me.deecaad.core.utils.LogLevel;
import org.jetbrains.annotations.NotNull;

public class SerializerInstancer
extends JarSearcher {
    public SerializerInstancer(@NotNull JarFile jar) {
        super(jar);
    }

    public List<Serializer<?>> createAllInstances(@NotNull ClassLoader classLoader, Class<?> ... classes) {
        List<Class<Serializer>> validClasses = this.findAllSubclasses(Serializer.class, classLoader, true, classes);
        ArrayList instances = new ArrayList(validClasses.size());
        for (Class<Serializer> validClass : validClasses) {
            Constructor<Serializer> emptyConstructor;
            try {
                emptyConstructor = validClass.getConstructor(new Class[0]);
            }
            catch (NoSuchMethodException e) {
                try {
                    validClass.getDeclaredMethod("getKeyword", new Class[0]);
                    MechanicsCore.debug.log(LogLevel.ERROR, "Found a serializer that uses getKeyword() but is missing an empty constructor!", "Please add empty constructor for class " + validClass.getSimpleName());
                }
                catch (NoSuchMethodException noSuchMethodException) {}
                continue;
            }
            catch (Throwable ex) {
                continue;
            }
            try {
                Serializer instance = emptyConstructor.newInstance(new Object[0]);
                if (instance.getKeyword() == null || instance instanceof InlineSerializer) continue;
                instances.add(instance);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return instances;
    }
}

