/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.core.file;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import me.deecaad.core.file.Serializer;
import me.deecaad.core.file.SerializerException;
import me.deecaad.core.utils.EnumUtil;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.entity.EntityType;
import org.jetbrains.annotations.NotNull;

public class SerializerEnumException
extends SerializerException {
    private final Set<String> options;
    private final String actual;
    private final boolean allowWildcard;

    public <T extends Enum<T>> SerializerEnumException(@NotNull String name, Class<T> enumClass, String actual, boolean allowWildcard, @NotNull String location) {
        super(name, SerializerEnumException.getMessages(enumClass, actual, allowWildcard), location);
        this.options = EnumUtil.getOptions(enumClass);
        this.actual = actual;
        this.allowWildcard = allowWildcard;
    }

    public <T extends Enum<T>> SerializerEnumException(@NotNull Serializer<?> serializer, Class<T> enumClass, String actual, boolean allowWildcard, @NotNull String location) {
        super(serializer, SerializerEnumException.getMessages(enumClass, actual, allowWildcard), location);
        this.options = EnumUtil.getOptions(enumClass);
        this.actual = actual;
        this.allowWildcard = allowWildcard;
        if (enumClass == Material.class) {
            this.options.removeIf(name -> name.startsWith("LEGACY_"));
        }
    }

    public Set<String> getOptions() {
        return new HashSet<String>(this.options);
    }

    public String getActual() {
        return this.actual;
    }

    public boolean isAllowWildcard() {
        return this.allowWildcard;
    }

    private static <T extends Enum<T>> String[] getMessages(Class<T> enumClass, String actual, boolean allowWildcard) {
        boolean usesWildcard = actual.startsWith("$");
        if (usesWildcard && !allowWildcard) {
            return new String[]{"You tried to use a wildcard ('$') when wildcards aren't allowed to be used!", SerializerEnumException.forValue(actual), SerializerEnumException.didYouMean(actual, enumClass)};
        }
        Object link = "https://github.com/WeaponMechanics/MechanicsMain/wiki/References";
        link = enumClass == Material.class ? (String)link + "#materials" : (enumClass == Sound.class ? (String)link + "#sounds" : (enumClass == Particle.class ? (String)link + "#particles" : (enumClass == EntityType.class ? (String)link + "#entities" : null)));
        LinkedList<Object> list = new LinkedList<Object>();
        list.add("Could not match config to any " + enumClass.getSimpleName());
        list.add(SerializerEnumException.forValue(actual));
        list.add(SerializerEnumException.didYouMean(actual, enumClass));
        if (link != null) {
            list.add(enumClass.getSimpleName() + " Reference: " + (String)link);
        }
        return list.toArray(new String[0]);
    }
}

