/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.core.file;

import java.util.List;
import me.deecaad.core.MechanicsCore;
import me.deecaad.core.file.Configuration;
import me.deecaad.core.file.SerializeData;
import me.deecaad.core.file.SerializerException;
import me.deecaad.core.utils.LogLevel;
import org.bukkit.configuration.ConfigurationSection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Serializer<T> {
    @Nullable
    default public String getKeyword() {
        return null;
    }

    @Nullable
    default public List<String> getParentKeywords() {
        return null;
    }

    default public boolean shouldSerialize(@NotNull SerializeData data) {
        return true;
    }

    @Nullable
    default public String useLater(ConfigurationSection configurationSection, String path) {
        return configurationSection.isString(path) ? configurationSection.getString(path) : null;
    }

    default public void tryPathTo(Configuration filledMap, String pathWhereToStore, String pathTo) {
        Object obj = filledMap.getObject(pathTo);
        if (!this.getClass().isInstance(obj)) {
            String[] splittedWhereToStore = pathWhereToStore.split("\\.");
            MechanicsCore.debug.log(LogLevel.ERROR, "Tried to use path to, but didn't find correct object.", "1) Make sure that you wrote path to correctly (" + pathTo + ")", "2) Make sure that the object at path to actually exists.", "3) Make sure that the object at path to doesn't also use path to as this may cause conflicts.", "4) If you feel like you weren't even intending to use path to, make sure that " + splittedWhereToStore[splittedWhereToStore.length - 1] + " doesn't match any serializer keyword!", "This is located at " + pathWhereToStore + " in configurations.");
            return;
        }
        filledMap.set(pathWhereToStore, obj);
    }

    @Nullable
    default public String getWikiLink() {
        return null;
    }

    default public boolean canUsePathTo() {
        return this.getKeyword() != null;
    }

    default public boolean letPassThrough(@NotNull String key) {
        return false;
    }

    @NotNull
    default public String getName() {
        String simple = this.getClass().getSimpleName();
        int index = simple.indexOf("Serializer");
        if (index > 0) {
            simple = simple.substring(0, index);
        }
        return simple;
    }

    @NotNull
    public T serialize(@NotNull SerializeData var1) throws SerializerException;
}

