/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.core.file;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import me.deecaad.core.file.BukkitConfig;
import me.deecaad.core.file.ConfigLike;
import me.deecaad.core.file.Configuration;
import me.deecaad.core.file.DuplicateKeyException;
import me.deecaad.core.file.IValidator;
import me.deecaad.core.file.LinkedConfig;
import me.deecaad.core.file.SerializeData;
import me.deecaad.core.file.Serializer;
import me.deecaad.core.file.SerializerException;
import me.deecaad.core.file.SerializerPathToException;
import me.deecaad.core.utils.Debugger;
import me.deecaad.core.utils.LogLevel;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileReader {
    private final Debugger debug;
    private final List<PathToSerializer> pathToSerializers;
    private final List<NestedPathToSerializer> nestedPathToSerializers;
    private final Map<String, Serializer<?>> serializers;
    private final List<ValidatorData> validatorDatas;
    private final Map<String, IValidator> validators;

    public FileReader(@NotNull Debugger debug, @Nullable List<Serializer<?>> serializers, @Nullable List<IValidator> validators) {
        this.debug = debug;
        this.serializers = new HashMap();
        this.validators = new HashMap<String, IValidator>();
        this.pathToSerializers = new ArrayList<PathToSerializer>();
        this.nestedPathToSerializers = new ArrayList<NestedPathToSerializer>();
        this.validatorDatas = new ArrayList<ValidatorData>();
        this.addSerializers(serializers);
        this.addValidators(validators);
    }

    public void addSerializers(List<Serializer<?>> serializers) {
        if (serializers != null && serializers.size() > 0) {
            for (Serializer<?> serializer : serializers) {
                this.addSerializer(serializer);
            }
        }
    }

    public void addSerializer(Serializer<?> serializer) {
        String serializerLowerCase = serializer.getKeyword().toLowerCase(Locale.ROOT);
        if (this.serializers.containsKey(serializerLowerCase)) {
            Serializer<?> alreadyAdded = this.serializers.get(serializerLowerCase);
            if (!alreadyAdded.getClass().isAssignableFrom(serializer.getClass())) {
                this.debug.log(LogLevel.ERROR, "Can't add serializer with keyword of " + serializer.getKeyword() + " because other serializer already has same keyword.", "Already added serializer is located at " + alreadyAdded.getClass().getName() + " and this new one was located at " + serializer.getClass().getName() + ".", "To override existing serializer either make new serializer extend existing serializer or implement Serializer<same data type as the existing one>.");
                return;
            }
            this.debug.log(LogLevel.DEBUG, "New serializer " + serializer.getClass().getName() + " will now override already added serializer " + alreadyAdded.getClass().getName());
        }
        this.serializers.put(serializerLowerCase, serializer);
    }

    public void addValidators(List<IValidator> validators) {
        if (validators != null && validators.size() > 0) {
            for (IValidator validator : validators) {
                this.addValidator(validator);
            }
        }
    }

    public void addValidator(IValidator validator) {
        String validatorLowerCase = validator.getKeyword().toLowerCase(Locale.ROOT);
        if (this.validators.containsKey(validatorLowerCase)) {
            IValidator alreadyAdded = this.validators.get(validatorLowerCase);
            if (!alreadyAdded.getClass().isAssignableFrom(validator.getClass())) {
                this.debug.log(LogLevel.ERROR, "Can't add validator with keyword of " + validator.getKeyword() + " because other validator already has same keyword.", "Already added validators is located at " + alreadyAdded.getClass().getName() + " and this new one was located at " + validator.getClass().getName() + ".");
                return;
            }
            this.debug.log(LogLevel.DEBUG, "New validator " + validator.getClass().getName() + " will now override already added validator " + alreadyAdded.getClass().getName());
        }
        this.validators.put(validatorLowerCase, validator);
    }

    public Configuration fillAllFiles(File directory, String ... ignoreFiles) {
        if (directory == null || directory.listFiles() == null) {
            throw new IllegalArgumentException("The given file MUST be a directory!");
        }
        Configuration filledMap = this.fillAllFilesLoop(directory, ignoreFiles);
        this.usePathToSerializersAndValidators(filledMap);
        LinkedConfig linked = (LinkedConfig)filledMap;
        linked.values().removeAll(Collections.singleton(null));
        return filledMap;
    }

    private Configuration fillAllFilesLoop(File directory, String ... ignoreFiles) {
        HashSet fileBlacklist = ignoreFiles == null ? new HashSet() : Arrays.stream(ignoreFiles).collect(Collectors.toSet());
        LinkedConfig filledMap = new LinkedConfig();
        for (File directoryFile : directory.listFiles()) {
            String name = directoryFile.getName();
            if (fileBlacklist.contains(name)) continue;
            try {
                if (name.endsWith(".yml")) {
                    Configuration newFilledMap = this.fillOneFile(directoryFile);
                    if (newFilledMap == null) continue;
                    filledMap.add(newFilledMap);
                    continue;
                }
                if (!directoryFile.isDirectory()) continue;
                filledMap.add(this.fillAllFilesLoop(directoryFile, new String[0]));
            }
            catch (DuplicateKeyException ex) {
                this.debug.log(LogLevel.ERROR, "Found duplicate keys in configuration!", "This occurs when you have 2 lines in configuration with the same name", "This is a huge error and WILL 100% cause issues in your guns.", "Duplicates Found: " + Arrays.toString(ex.getKeys()), "Found in file: " + name);
                this.debug.log(LogLevel.DEBUG, "Duplicate Key Exception: ", ex);
            }
        }
        return filledMap;
    }

    public Configuration fillOneFile(File file) {
        LinkedConfig filledMap = new LinkedConfig();
        String startsWithDeny = null;
        Serializer<?> savedSerializer = null;
        YamlConfiguration configuration = YamlConfiguration.loadConfiguration((File)file);
        for (String key : configuration.getKeys(true)) {
            block15: {
                Serializer<?> serializer;
                String lastKey;
                String[] keySplit;
                block16: {
                    IValidator validator;
                    block17: {
                        String keyWithoutFirstKey;
                        if (startsWithDeny != null && !key.startsWith(startsWithDeny)) {
                            startsWithDeny = null;
                            savedSerializer = null;
                        }
                        if ((keySplit = key.split("\\.")).length <= 0) break block15;
                        lastKey = keySplit[keySplit.length - 1].toLowerCase(Locale.ROOT);
                        if (startsWithDeny != null || (validator = this.validators.get(lastKey)) == null) break block16;
                        String firstKey = keySplit[0].toLowerCase(Locale.ROOT);
                        String string = keyWithoutFirstKey = keySplit.length == 1 ? null : key.substring(firstKey.length());
                        if (keyWithoutFirstKey == null || validator.getAllowedPaths() == null) break block17;
                        if (!validator.getAllowedPaths().stream().anyMatch(keyWithoutFirstKey::equalsIgnoreCase)) break block16;
                    }
                    this.validatorDatas.add(new ValidatorData(validator, file, (ConfigurationSection)configuration, key));
                    if (validator.denyKeys()) {
                        startsWithDeny = key;
                    }
                }
                if ((serializer = this.serializers.get(lastKey)) != null) {
                    String keyWithoutLastKey;
                    String string = keyWithoutLastKey = keySplit.length == 1 ? null : key.substring(0, key.length() - lastKey.length() - 1);
                    if (startsWithDeny != null) {
                        if (serializer.getParentKeywords() == null || keyWithoutLastKey == null) continue;
                        if (serializer.getParentKeywords().stream().noneMatch(keyWithoutLastKey::endsWith)) continue;
                    }
                    if (!serializer.shouldSerialize(new SerializeData(serializer, file, key, (ConfigLike)new BukkitConfig((ConfigurationSection)configuration)))) {
                        this.debug.debug("Skipping " + key + " due to skip");
                        continue;
                    }
                    String pathTo = serializer.useLater((ConfigurationSection)configuration, key);
                    if (serializer.canUsePathTo() && pathTo != null) {
                        this.pathToSerializers.add(new PathToSerializer(serializer, key, pathTo));
                        continue;
                    }
                    try {
                        Object valid = serializer.serialize(new SerializeData(serializer, file, key, (ConfigLike)new BukkitConfig((ConfigurationSection)configuration)));
                        filledMap.set(key, valid);
                        if (startsWithDeny != null) continue;
                        startsWithDeny = key;
                        savedSerializer = serializer;
                        continue;
                    }
                    catch (SerializerPathToException ex) {
                        this.nestedPathToSerializers.add(new NestedPathToSerializer(serializer, key, ex));
                        if (startsWithDeny != null) continue;
                        startsWithDeny = key;
                        savedSerializer = serializer;
                        continue;
                    }
                    catch (SerializerException ex) {
                        ex.log(this.debug);
                        if (startsWithDeny != null) continue;
                        startsWithDeny = key;
                        savedSerializer = serializer;
                        continue;
                    }
                    catch (Exception ex) {
                        throw new InternalError("Unhandled caught exception from serializer " + String.valueOf(serializer) + "!", ex);
                    }
                }
            }
            if (startsWithDeny != null && key.startsWith(startsWithDeny) && (savedSerializer == null || !savedSerializer.letPassThrough(key)) || configuration.isConfigurationSection(key)) continue;
            Object object = configuration.get(key);
            filledMap.set(key, object);
        }
        if (filledMap.getKeys().isEmpty()) {
            return null;
        }
        return filledMap;
    }

    public Configuration usePathToSerializersAndValidators(Configuration filledMap) {
        SerializeData data;
        for (NestedPathToSerializer nestedPathTo : this.nestedPathToSerializers) {
            try {
                data = new SerializeData(nestedPathTo.serializer, nestedPathTo.ex.data.file, nestedPathTo.path, nestedPathTo.ex.data.config);
                data.pathToConfig = filledMap;
                Object serialized = data.of().serialize(nestedPathTo.serializer);
                filledMap.set(nestedPathTo.path, serialized);
            }
            catch (SerializerException ex) {
                ex.log(this.debug);
            }
        }
        for (PathToSerializer pathToSerializer : this.pathToSerializers) {
            pathToSerializer.serializer.tryPathTo(filledMap, pathToSerializer.pathWhereToStore, pathToSerializer.pathTo);
        }
        for (ValidatorData validatorData : this.validatorDatas) {
            data = new SerializeData(validatorData.validator.getKeyword(), validatorData.file, validatorData.path, (ConfigLike)new BukkitConfig(validatorData.configurationSection));
            data.pathToConfig = filledMap;
            if (!validatorData.validator.shouldValidate(data)) {
                this.debug.debug("Skipping " + validatorData.path + " due to skip");
                continue;
            }
            try {
                validatorData.validator.validate(filledMap, data);
            }
            catch (SerializerException ex) {
                ex.log(this.debug);
            }
            catch (Exception ex) {
                throw new InternalError("Unhandled caught exception from validator " + String.valueOf(validatorData.validator) + "!", ex);
            }
        }
        return filledMap;
    }

    public record ValidatorData(IValidator validator, File file, ConfigurationSection configurationSection, String path) {
    }

    public record PathToSerializer(Serializer<?> serializer, String pathWhereToStore, String pathTo) {
    }

    public record NestedPathToSerializer(Serializer<?> serializer, String path, SerializerPathToException ex) {
    }
}

