/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.core.events.triggers;

import com.google.common.collect.ImmutableList;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import me.deecaad.core.MechanicsCore;
import me.deecaad.core.compatibility.CompatibilityAPI;
import me.deecaad.core.events.EntityEquipmentEvent;
import me.deecaad.core.utils.LogLevel;
import me.deecaad.core.utils.ReflectionUtil;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class EquipListener
implements Listener {
    private static final Field playerInventoryField;
    private static final Class<?> playerInventoryClass;
    private static final Field inventoryField;
    private static final Field armorField;
    private static final Field offHandField;
    private static final Field hotBarSlotField;
    private static final Field combinedField;
    public static final EquipListener SINGLETON;
    private final Set<Player> dropCancelledPlayers = new HashSet<Player>();
    private final Set<Player> ignoreGiveDropPlayers = new HashSet<Player>();

    private EquipListener() {
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent event) {
        this.inject(event.getPlayer());
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onSwap(PlayerItemHeldEvent e) {
        Player player = e.getPlayer();
        PlayerInventory inv = player.getInventory();
        if (!EquipListener.isEmpty(inv.getItem(e.getNewSlot())) || !EquipListener.isEmpty(inv.getItem(e.getPreviousSlot()))) {
            ItemStack old = inv.getItem(e.getPreviousSlot());
            ItemStack current = inv.getItem(e.getNewSlot());
            Bukkit.getPluginManager().callEvent((Event)new EntityEquipmentEvent((Entity)player, EquipmentSlot.HAND, old, current));
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onCommand(PlayerCommandPreprocessEvent event) {
        String commandLine = event.getMessage().toLowerCase(Locale.ROOT);
        final Player player = event.getPlayer();
        if (commandLine.startsWith("/give") || commandLine.startsWith("/minecraft:give")) {
            final Listener listener = new Listener(){

                @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
                public void onDrop(PlayerDropItemEvent event) {
                    if (player.equals((Object)event.getPlayer())) {
                        EquipListener.this.ignoreGiveDropPlayers.add(player);
                    }
                }
            };
            Bukkit.getPluginManager().registerEvents(listener, (Plugin)MechanicsCore.getPlugin());
            new BukkitRunnable(){

                public void run() {
                    HandlerList.unregisterAll((Listener)listener);
                }
            }.runTask((Plugin)MechanicsCore.getPlugin());
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onInventoryDrop(InventoryClickEvent event) {
        if (event.getSlot() == -999 && !EquipListener.isEmpty(event.getCursor()) && event.getWhoClicked() instanceof Player) {
            this.ignoreGiveDropPlayers.add((Player)event.getWhoClicked());
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onDrop(PlayerDropItemEvent event) {
        Player player = event.getPlayer();
        if (event.isCancelled()) {
            this.dropCancelledPlayers.add(player);
            return;
        }
        if (this.ignoreGiveDropPlayers.remove(player)) {
            return;
        }
        PlayerInventory inv = player.getInventory();
        ItemStack item = inv.getItemInMainHand();
        if (EquipListener.isEmpty(item)) {
            Bukkit.getPluginManager().callEvent((Event)new EntityEquipmentEvent((Entity)player, EquipmentSlot.HAND, event.getItemDrop().getItemStack(), null));
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onPlace(BlockPlaceEvent event) {
        if (event.getItemInHand().getAmount() - 1 == 0) {
            Bukkit.getPluginManager().callEvent((Event)new EntityEquipmentEvent((Entity)event.getPlayer(), event.getHand(), new ItemStack(event.getBlockPlaced().getType()), null));
        }
    }

    public void inject(Player player) {
        Object handle = CompatibilityAPI.getCompatibility().getEntityPlayer(player);
        Object playerInventory = ReflectionUtil.invokeField(playerInventoryField, handle);
        List<Object> inventory = CompatibilityAPI.getEntityCompatibility().generateNonNullList(36, (old, current, index) -> {
            if (EquipListener.isIllegalModification()) {
                return;
            }
            if (this.dropCancelledPlayers.remove(player)) {
                return;
            }
            int hotBar = (Integer)ReflectionUtil.invokeField(hotBarSlotField, playerInventory);
            if (hotBar >= 0 && hotBar < 9 && hotBar == index) {
                Bukkit.getPluginManager().callEvent((Event)new EntityEquipmentEvent((Entity)player, EquipmentSlot.HAND, (ItemStack)old, (ItemStack)current));
            }
        });
        List<Object> armor = CompatibilityAPI.getEntityCompatibility().generateNonNullList(4, (old, current, index) -> {
            if (EquipListener.isIllegalModification()) {
                return;
            }
            EquipmentSlot slot = switch (index) {
                case 0 -> EquipmentSlot.FEET;
                case 1 -> EquipmentSlot.LEGS;
                case 2 -> EquipmentSlot.CHEST;
                case 3 -> EquipmentSlot.HEAD;
                default -> throw new IndexOutOfBoundsException("Index out of bounds: " + index + ", for list " + String.valueOf(this));
            };
            Bukkit.getPluginManager().callEvent((Event)new EntityEquipmentEvent((Entity)player, slot, (ItemStack)old, (ItemStack)current));
        });
        List<Object> offhand = CompatibilityAPI.getEntityCompatibility().generateNonNullList(1, (old, current, index) -> {
            if (EquipListener.isIllegalModification()) {
                return;
            }
            Bukkit.getPluginManager().callEvent((Event)new EntityEquipmentEvent((Entity)player, EquipmentSlot.OFF_HAND, (ItemStack)old, (ItemStack)current));
        });
        List oldItems = (List)ReflectionUtil.invokeField(inventoryField, playerInventory);
        for (int i = 0; i < oldItems.size(); ++i) {
            inventory.set(i, oldItems.get(i));
        }
        List oldArmor = (List)ReflectionUtil.invokeField(armorField, playerInventory);
        for (int i = 0; i < oldArmor.size(); ++i) {
            armor.set(i, oldArmor.get(i));
        }
        offhand.set(0, ((List)ReflectionUtil.invokeField(offHandField, playerInventory)).get(0));
        ReflectionUtil.setField(inventoryField, playerInventory, inventory);
        ReflectionUtil.setField(armorField, playerInventory, armor);
        ReflectionUtil.setField(offHandField, playerInventory, offhand);
        ReflectionUtil.setField(combinedField, playerInventory, ImmutableList.of(inventory, armor, offhand));
    }

    private static boolean isEmpty(ItemStack item) {
        return item == null || item.getType() == Material.AIR;
    }

    private static boolean isIllegalModification() {
        if (Bukkit.isPrimaryThread()) {
            return false;
        }
        StackWalker STACK_WALKER = StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE);
        Optional optional = STACK_WALKER.walk(stream -> stream.filter(frame -> EquipListener.isPlugin(frame.getDeclaringClass())).findFirst());
        if (optional.isEmpty()) {
            MechanicsCore.debug.log(LogLevel.WARN, "Unknown async call to add inventory", new Throwable());
            return true;
        }
        JavaPlugin plugin = JavaPlugin.getProvidingPlugin(((StackWalker.StackFrame)optional.get()).getDeclaringClass());
        PluginDescriptionFile desc = plugin.getDescription();
        String location = ((StackWalker.StackFrame)optional.get()).getDeclaringClass().getName() + "." + ((StackWalker.StackFrame)optional.get()).getMethodName() + "(" + ((StackWalker.StackFrame)optional.get()).getFileName() + ":" + ((StackWalker.StackFrame)optional.get()).getLineNumber() + ")";
        plugin.getLogger().log(Level.SEVERE, String.format("Nag author(s) %s of %s-%s about their async inventory modification at %s", desc.getAuthors(), desc.getName(), desc.getVersion(), location));
        MechanicsCore.debug.error("Found a bad plugin '" + desc.getName() + "' for modifying inventory async.");
        return true;
    }

    private static boolean isPlugin(Class<?> clazz) {
        try {
            JavaPlugin plugin = JavaPlugin.getProvidingPlugin(clazz);
            return !"MechanicsCore".equals(plugin.getName());
        }
        catch (IllegalArgumentException ex) {
            return false;
        }
    }

    static {
        Class<?> humanClass = ReflectionUtil.getNMSClass("world.entity.player", "EntityHuman");
        playerInventoryClass = ReflectionUtil.getNMSClass("world.entity.player", "PlayerInventory");
        playerInventoryField = ReflectionUtil.getField(humanClass, playerInventoryClass);
        Class<?> nonNullListClass = ReflectionUtil.getNMSClass("core", "NonNullList");
        inventoryField = ReflectionUtil.getField(playerInventoryClass, nonNullListClass, 0);
        armorField = ReflectionUtil.getField(playerInventoryClass, nonNullListClass, 1);
        offHandField = ReflectionUtil.getField(playerInventoryClass, nonNullListClass, 2);
        combinedField = ReflectionUtil.getField(playerInventoryClass, List.class, 3);
        hotBarSlotField = ReflectionUtil.getField(playerInventoryClass, Integer.TYPE, 0, true);
        SINGLETON = new EquipListener();
    }
}

