/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.core.events;

import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.event.HandlerList;
import org.bukkit.event.entity.EntityEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class EntityEquipmentEvent
extends EntityEvent {
    public static final HandlerList HANDLERS = new HandlerList();
    private final EquipmentSlot slot;
    private final ItemStack dequipped;
    private final ItemStack equipped;

    public EntityEquipmentEvent(Entity what, EquipmentSlot slot, ItemStack dequipped, ItemStack equipped) {
        super(what);
        this.slot = slot;
        this.dequipped = dequipped;
        this.equipped = equipped;
    }

    @NotNull
    public EquipmentSlot getSlot() {
        return this.slot;
    }

    public boolean isDequipping() {
        return this.dequipped != null && this.dequipped.getType() != Material.AIR;
    }

    public boolean isEquipping() {
        return this.equipped != null && this.equipped.getType() != Material.AIR;
    }

    public ItemStack getDequipped() {
        return this.dequipped;
    }

    public ItemStack getEquipped() {
        return this.equipped;
    }

    public boolean isArmor() {
        return switch (this.slot) {
            case EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET -> true;
            default -> false;
        };
    }

    public String toString() {
        return "EquipEvent{slot=" + String.valueOf(this.slot) + ", dequipped=" + String.valueOf(this.dequipped) + ", equipped=" + String.valueOf(this.equipped) + "}";
    }

    public HandlerList getHandlers() {
        return HANDLERS;
    }

    public static HandlerList getHandlerList() {
        return HANDLERS;
    }
}

