/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.core.compatibility.nbt;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import org.bukkit.inventory.meta.tags.ItemTagAdapterContext;
import org.bukkit.inventory.meta.tags.ItemTagType;
import org.jetbrains.annotations.NotNull;

public class StringTagType
implements ItemTagType<byte[], String[]> {
    public static final StringTagType INSTANCE = new StringTagType();

    private StringTagType() {
    }

    @NotNull
    public Class<byte[]> getPrimitiveType() {
        return byte[].class;
    }

    @NotNull
    public Class<String[]> getComplexType() {
        return String[].class;
    }

    public byte @NotNull [] toPrimitive(String[] complex, @NotNull ItemTagAdapterContext context) {
        byte[][] allBytes = new byte[complex.length][];
        int total = 0;
        for (int i = 0; i < allBytes.length; ++i) {
            byte[] bytes = complex[i].getBytes(StandardCharsets.UTF_8);
            allBytes[i] = bytes;
            total += bytes.length;
        }
        ByteBuffer buffer = ByteBuffer.allocate(total + allBytes.length * 4);
        for (byte[] bytes : allBytes) {
            buffer.putInt(bytes.length);
            buffer.put(bytes);
        }
        return buffer.array();
    }

    public String @NotNull [] fromPrimitive(byte @NotNull [] primitive, @NotNull ItemTagAdapterContext context) {
        ByteBuffer buffer = ByteBuffer.wrap(primitive);
        ArrayList<String> list = new ArrayList<String>();
        while (buffer.remaining() > 0 && buffer.remaining() >= 4) {
            int stringLength = buffer.getInt();
            if (buffer.remaining() < stringLength) break;
            byte[] stringBytes = new byte[stringLength];
            buffer.get(stringBytes);
            list.add(new String(stringBytes, StandardCharsets.UTF_8));
        }
        return list.toArray(new String[0]);
    }
}

