/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.core.compatibility.entity;

import java.util.List;
import me.deecaad.core.compatibility.HitBox;
import me.deecaad.core.compatibility.entity.FakeEntity;
import me.deecaad.core.compatibility.equipevent.TriIntConsumer;
import me.deecaad.core.utils.MinecraftVersions;
import org.bukkit.Bukkit;
import org.bukkit.EntityEffect;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Statistic;
import org.bukkit.block.BlockState;
import org.bukkit.entity.ComplexEntityPart;
import org.bukkit.entity.ComplexLivingEntity;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityResurrectEvent;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface EntityCompatibility {
    public static final EntityType ITEM_ENTITY = MinecraftVersions.TRAILS_AND_TAILS.get(5).isAtLeast() ? EntityType.ITEM : EntityType.valueOf((String)"DROPPED_ITEM");

    default public HitBox getHitBox(Entity entity) {
        if (entity.isInvulnerable() || !entity.getType().isAlive() || entity.isDead()) {
            return null;
        }
        HitBox hitBox = new HitBox(entity.getLocation().toVector(), this.getLastLocation(entity)).grow(entity.getWidth(), entity.getHeight());
        hitBox.setLivingEntity((LivingEntity)entity);
        if (entity instanceof ComplexLivingEntity) {
            for (ComplexEntityPart entityPart : ((ComplexLivingEntity)entity).getParts()) {
                BoundingBox boxPart = entityPart.getBoundingBox();
                hitBox.addVoxelShapePart(new HitBox(boxPart.getMinX(), boxPart.getMinY(), boxPart.getMinZ(), boxPart.getMaxX(), boxPart.getMaxY(), boxPart.getMaxZ()));
            }
        }
        return hitBox;
    }

    public Vector getLastLocation(Entity var1);

    default public double getAbsorption(@NotNull LivingEntity entity) {
        return entity.getAbsorptionAmount();
    }

    default public void setAbsorption(@NotNull LivingEntity entity, double absorption) {
        entity.setAbsorptionAmount(absorption);
    }

    public List<Object> generateNonNullList(int var1, TriIntConsumer<ItemStack, ItemStack> var2);

    public FakeEntity generateFakeEntity(Location var1, EntityType var2, Object var3);

    default public FakeEntity generateFakeEntity(Location location, ItemStack item) {
        return this.generateFakeEntity(location, ITEM_ENTITY, item);
    }

    default public FakeEntity generateFakeEntity(Location location, BlockState block) {
        return this.generateFakeEntity(location, EntityType.FALLING_BLOCK, block);
    }

    default public boolean tryUseTotemOfUndying(@NotNull LivingEntity entity) {
        EntityEquipment equipment = entity.getEquipment();
        ItemStack mainHand = equipment == null ? null : equipment.getItemInMainHand();
        ItemStack offHand = equipment == null ? null : equipment.getItemInOffHand();
        EquipmentSlot hand = null;
        if (mainHand != null && mainHand.getType() == Material.TOTEM_OF_UNDYING) {
            hand = EquipmentSlot.HAND;
        } else if (offHand != null && offHand.getType() == Material.TOTEM_OF_UNDYING) {
            hand = EquipmentSlot.OFF_HAND;
        }
        ItemStack totem = hand == null ? null : (hand == EquipmentSlot.HAND ? mainHand : offHand);
        EntityResurrectEvent event = MinecraftVersions.WILD_UPDATE.isAtLeast() ? new EntityResurrectEvent(entity, hand) : new EntityResurrectEvent(entity);
        event.setCancelled(hand == null);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return false;
        }
        if (totem != null && totem.getType() == Material.TOTEM_OF_UNDYING) {
            totem.setAmount(totem.getAmount() - 1);
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            player.incrementStatistic(Statistic.USE_ITEM, Material.TOTEM_OF_UNDYING);
        }
        entity.setHealth(1.0);
        for (PotionEffect potion : entity.getActivePotionEffects()) {
            entity.removePotionEffect(potion.getType());
        }
        entity.addPotionEffect(new PotionEffect(PotionEffectType.REGENERATION, 900, 1));
        entity.addPotionEffect(new PotionEffect(PotionEffectType.ABSORPTION, 100, 1));
        entity.addPotionEffect(new PotionEffect(PotionEffectType.FIRE_RESISTANCE, 800, 0));
        entity.playEffect(EntityEffect.TOTEM_RESURRECT);
        return true;
    }

    public int getId(Object var1);

    public void setSlot(Player var1, EquipmentSlot var2, @Nullable ItemStack var3);

    public Object generateMetaPacket(Entity var1);

    public void modifyMetaPacket(Object var1, EntityMeta var2, boolean var3);

    public static enum EntityMeta {
        FIRE(0),
        SNEAKING(1),
        UNUSED(2),
        SPRINTING(3),
        SWIMMING(4),
        INVISIBLE(5),
        GLOWING(6),
        GLIDING(7);

        private final byte mask;

        private EntityMeta(int location) {
            this.mask = (byte)(1 << location);
        }

        public byte getMask() {
            return this.mask;
        }

        public byte set(byte data, boolean is) {
            return (byte)(is ? data | this.mask : data & ~this.mask);
        }
    }
}

