/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.core.commands.wrappers;

public class DoubleRange {
    private final double min;
    private final double max;

    public DoubleRange(double min, double max) {
        if (Double.isNaN(min) || Double.isNaN(max)) {
            throw new NumberFormatException(min + ".." + max + " is not a valid range! Use real numbers!");
        }
        this.min = Math.min(min, max);
        this.max = Math.max(min, max);
    }

    public double getMin() {
        return this.min;
    }

    public DoubleRange setMin(double min) {
        return new DoubleRange(min, this.max);
    }

    public double getMax() {
        return this.max;
    }

    public DoubleRange setMax(double max) {
        return new DoubleRange(this.min, max);
    }

    public boolean inRange(double point) {
        return point >= this.min && point <= this.max;
    }
}

