/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.core.commands.arguments;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Locale;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import me.deecaad.core.commands.arguments.CommandArgumentType;
import me.deecaad.core.utils.EnumUtil;
import me.deecaad.core.utils.SerializerUtil;
import org.bukkit.entity.EntityType;

public class EnumArgumentType<T extends Enum<T>>
extends CommandArgumentType<T> {
    private final Class<T> clazz;

    public EnumArgumentType(Class<T> clazz) {
        this.clazz = clazz;
        if (clazz == EntityType.class) {
            throw new IllegalArgumentException("Use EntityTypeArgumentType");
        }
    }

    public Class<T> getClazz() {
        return this.clazz;
    }

    @Override
    public ArgumentType<?> getBrigadierType() {
        return StringArgumentType.word();
    }

    @Override
    public T parse(CommandContext<Object> context, String key) throws CommandSyntaxException {
        String str = (String)context.getArgument(key, String.class);
        Optional<T> optional = EnumUtil.getIfPresent(this.clazz, str);
        if (optional.isPresent()) {
            return (T)((Enum)optional.get());
        }
        throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherParseException().create((Object)("Did you mean: " + SerializerUtil.didYouMeanEnum(str, this.clazz)));
    }

    @Override
    public CompletableFuture<Suggestions> suggestions(CommandContext<Object> context, SuggestionsBuilder builder) {
        String remaining = builder.getRemaining().toLowerCase(Locale.ROOT);
        for (String str : EnumUtil.getOptions(this.clazz)) {
            if (!str.toLowerCase(Locale.ROOT).startsWith(remaining)) continue;
            builder.suggest(str);
        }
        return builder.buildFuture();
    }
}

