/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.core.commands.arguments;

import com.mojang.brigadier.LiteralMessage;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.awt.Color;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import me.deecaad.core.commands.arguments.CommandArgumentType;
import me.deecaad.core.utils.EnumUtil;
import org.bukkit.ChatColor;

public class ColorArgumentType
extends CommandArgumentType<org.bukkit.Color> {
    @Override
    public ArgumentType<?> getBrigadierType() {
        return StringArgumentType.word();
    }

    @Override
    public org.bukkit.Color parse(CommandContext<Object> context, String key) throws CommandSyntaxException {
        String input = (String)context.getArgument(key, String.class);
        Optional<ChatColor> optional = EnumUtil.getIfPresent(ChatColor.class, input);
        if (optional.isPresent()) {
            Color color = optional.get().asBungee().getColor();
            return org.bukkit.Color.fromRGB((int)(0xFF & color.getRed()), (int)(0xFF & color.getGreen()), (int)(0xFF & color.getBlue()));
        }
        try {
            int rgb = 0xFFFFFF & Integer.parseInt(input, 16);
            return org.bukkit.Color.fromRGB((int)rgb);
        }
        catch (NumberFormatException ex) {
            throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherParseException().create((Object)("For hex: " + input));
        }
    }

    @Override
    public CompletableFuture<Suggestions> suggestions(CommandContext<Object> context, SuggestionsBuilder builder) {
        builder.suggest("ffffff", (Message)new LiteralMessage("white"));
        builder.suggest("ff0000", (Message)new LiteralMessage("red"));
        builder.suggest("00ff00", (Message)new LiteralMessage("green"));
        builder.suggest("0000ff", (Message)new LiteralMessage("blue"));
        builder.suggest("000000", (Message)new LiteralMessage("black"));
        for (ChatColor color : EnumUtil.getValues(ChatColor.class)) {
            if (color.asBungee().getColor() == null) continue;
            builder.suggest(color.name());
        }
        return builder.buildFuture();
    }
}

