/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.core.commands;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.LiteralMessage;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import me.deecaad.core.MechanicsCore;
import me.deecaad.core.commands.Argument;
import me.deecaad.core.commands.CommandBuilder;
import me.deecaad.core.commands.CommandData;
import me.deecaad.core.commands.Tooltip;
import me.deecaad.core.commands.arguments.CommandArgumentType;
import me.deecaad.core.commands.arguments.LiteralArgumentType;
import me.deecaad.core.commands.arguments.MultiLiteralArgumentType;
import me.deecaad.core.commands.arguments.StringArgumentType;
import me.deecaad.core.compatibility.CompatibilityAPI;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;

public class BrigadierCommand
implements Command<Object> {
    private final CommandBuilder builder;

    public BrigadierCommand(CommandBuilder builder) {
        this.builder = builder;
        CommandDispatcher<Object> dispatcher = CompatibilityAPI.getCommandCompatibility().getCommandDispatcher();
        LiteralArgumentBuilder result = (LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)builder.label).requires(builder.requirements());
        if (builder.args.isEmpty()) {
            result.executes((Command)this);
        } else {
            result.then(this.buildArguments(builder.args));
        }
        dispatcher.register(result);
        MechanicsCore.debug.debug("Registering Command: " + String.valueOf(builder));
    }

    public int run(CommandContext<Object> context) throws CommandSyntaxException {
        CommandSender sender = CompatibilityAPI.getCommandCompatibility().getCommandSender(context);
        if (!this.builder.executor.getExecutor().isInstance(sender)) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + this.builder.label + " is a " + this.builder.executor.getExecutor().getSimpleName() + " only command.");
            return -1;
        }
        try {
            this.builder.executor.execute((CommandSender)sender, this.parseBrigadierArguments(context));
            return 0;
        }
        catch (CommandSyntaxException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Some error occurred whilst executing command. Check console for error. ");
            ex.printStackTrace();
            return -1;
        }
    }

    private Object[] parseBrigadierArguments(CommandContext<Object> context) throws Exception {
        ArrayList<Object> temp = new ArrayList<Object>(this.builder.args.size());
        for (Argument<Object> argument : this.builder.args) {
            if (!argument.isListed()) continue;
            temp.add(argument.parse(context, argument.getName()));
        }
        Collections.addAll(temp, this.builder.optionalDefaultValues);
        return temp.toArray();
    }

    private ArgumentBuilder<Object, ?> buildArguments(List<Argument<Object>> args) {
        if (args == null || args.isEmpty()) {
            throw new IllegalArgumentException("empty args");
        }
        LiteralArgumentBuilder builder = null;
        for (int i = args.size() - 1; i >= 0; --i) {
            LiteralArgumentBuilder temp;
            Argument<Object> argument = args.get(i);
            CommandArgumentType<Object> commandArgumentType = argument.getType();
            if (commandArgumentType instanceof LiteralArgumentType) {
                LiteralArgumentType literal = (LiteralArgumentType)commandArgumentType;
                temp = LiteralArgumentBuilder.literal((String)literal.getLiteral());
            } else {
                RequiredArgumentBuilder required = RequiredArgumentBuilder.argument((String)argument.getName(), argument.getType().getBrigadierType());
                SuggestionProvider def = (context, suggestions) -> argument.getType().suggestions((CommandContext<Object>)context, suggestions);
                SuggestionProvider<Object> custom = this.buildSuggestionProvider(argument);
                SuggestionProvider label = (context, suggestions) -> suggestions.suggest("<" + argument.getName() + ">", (Message)(argument.description == null ? null : new LiteralMessage(argument.description))).buildFuture();
                SuggestionProvider combined = (context, suggestions) -> {
                    ArrayList<CompletableFuture> all = new ArrayList<CompletableFuture>(3);
                    if (argument.isReplaceSuggestions) {
                        all.add(custom.getSuggestions(context, suggestions));
                    } else if (argument.suggestions != null) {
                        all.addAll(Arrays.asList(def.getSuggestions(context, suggestions), custom.getSuggestions(context, suggestions)));
                    } else {
                        all.add(def.getSuggestions(context, suggestions));
                    }
                    if (argument.getType().includeName()) {
                        all.add(label.getSuggestions(context, suggestions));
                    }
                    CompletableFuture result = new CompletableFuture();
                    CompletableFuture.allOf(all.toArray(new CompletableFuture[0])).thenRun(() -> {
                        List list = all.stream().map(CompletableFuture::join).collect(Collectors.toList());
                        Suggestions merged = Suggestions.merge((String)context.getInput(), list);
                        result.complete(merged);
                    });
                    return result;
                };
                required.suggests(combined);
                temp = required;
            }
            if (builder == null) {
                temp.requires(argument.requirements()).executes((Command)this);
            } else {
                temp.requires(argument.requirements()).then(builder);
            }
            builder = temp;
        }
        return builder;
    }

    private SuggestionProvider<Object> buildSuggestionProvider(Argument<?> argument) {
        return (context, builder) -> {
            CommandSender sender = CompatibilityAPI.getCommandCompatibility().getCommandSender((CommandContext<Object>)context);
            ArrayList<Object> previousArguments = new ArrayList<Object>();
            for (Argument<Object> arg : this.builder.args) {
                if (arg == argument) break;
                if (!arg.isListed()) continue;
                previousArguments.add(arg.parse((CommandContext<Object>)context, arg.getName()));
            }
            CommandData data = new CommandData(sender, previousArguments.toArray(), builder.getInput(), builder.getRemaining());
            String remaining = builder.getRemaining().toLowerCase(Locale.ROOT);
            for (Tooltip suggestion : argument.suggestions == null ? new Tooltip[]{} : argument.suggestions.apply(data)) {
                if (!suggestion.suggestion().toLowerCase(Locale.ROOT).startsWith(remaining)) continue;
                LiteralMessage tooltipMsg = suggestion.tip() == null ? null : new LiteralMessage(suggestion.tip());
                builder.suggest(suggestion.suggestion(), (Message)tooltipMsg);
            }
            return builder.buildFuture();
        };
    }

    static void register(CommandBuilder builder) {
        CommandBuilder clone;
        Argument<Object> arg;
        int i;
        if (builder.friend != null) {
            BrigadierCommand.register(builder.friend);
        }
        if (!builder.subcommands.isEmpty()) {
            for (CommandBuilder subcommand : builder.subcommands) {
                BrigadierCommand.unPack(builder.clone(), new ArrayList(), subcommand);
            }
        }
        for (i = 0; i < builder.args.size(); ++i) {
            StringArgumentType type;
            arg = builder.args.get(i);
            if (arg.getType() instanceof MultiLiteralArgumentType) {
                for (String literal : ((MultiLiteralArgumentType)arg.getType()).getLiterals()) {
                    ArrayList<Argument<Object>> copy = new ArrayList<Argument<Object>>(builder.args);
                    Argument<String> replace = new Argument<String>(literal, new LiteralArgumentType(literal)).withPermission(arg.permission).withRequirements(arg.requirements).setListed(arg.listed);
                    copy.set(i, replace);
                    CommandBuilder clone2 = builder.clone();
                    clone2.args = copy;
                    BrigadierCommand.register(clone2);
                }
                return;
            }
            String[] stringArray = arg.getType();
            if (!(stringArray instanceof StringArgumentType) || (type = (StringArgumentType)stringArray).getLiterals() == null || type.getLiterals().isEmpty()) continue;
            for (LiteralArgumentType literal : type.getLiterals()) {
                ArrayList<Argument<Object>> copy = new ArrayList<Argument<Object>>(builder.args);
                copy.set(i, new Argument<String>(literal.getLiteral(), literal));
                CommandBuilder clone3 = builder.clone();
                clone3.args = copy;
                BrigadierCommand.register(clone3);
            }
        }
        for (i = builder.args.size() - 1; i >= 0; --i) {
            arg = builder.args.get(i);
            if (arg.isRequired()) continue;
            clone = builder.clone();
            clone.args = new ArrayList<Argument<Object>>(clone.args.subList(0, i));
            Object[] defaults = new Object[clone.optionalDefaultValues.length + 1];
            System.arraycopy(clone.optionalDefaultValues, 0, defaults, 1, defaults.length - 1);
            defaults[0] = arg.getDefaultValue();
            clone.optionalDefaultValues = defaults;
            BrigadierCommand.register(clone);
            break;
        }
        if (builder.executor == null) {
            MechanicsCore.debug.warn("No executor for: " + String.valueOf(builder));
            return;
        }
        if (builder.friend != null) {
            BrigadierCommand.register(builder.friend);
        }
        new BrigadierCommand(builder.clone());
        for (String alias : builder.aliases) {
            clone = builder.clone();
            clone.label = alias;
            new BrigadierCommand(clone);
        }
    }

    private static void unPack(CommandBuilder root, List<Argument<?>> arguments, CommandBuilder subcommand) {
        MultiLiteralArgumentType literals = new MultiLiteralArgumentType(subcommand.label, subcommand.aliases.toArray(new String[0]));
        Argument<String> argument = new Argument<String>("sub-command", literals).withPermission(subcommand.permission).withRequirements(subcommand.requirements).setListed(false);
        arguments.add(argument);
        if (subcommand.executor != null) {
            CommandBuilder temp = root.clone();
            temp.args = arguments;
            temp.withArguments(subcommand.args);
            temp.executes(subcommand.executor);
            temp.subcommands = new ArrayList<CommandBuilder>();
            BrigadierCommand.register(temp);
            if (subcommand.friend != null) {
                Argument<?> arg;
                for (int i = arguments.size() - 1; i >= 0 && !(arg = arguments.get(i)).getName().equals("sub-command"); --i) {
                    if (!arg.isRequired()) continue;
                    CommandBuilder help = root.clone();
                    help.args = arguments.subList(0, i);
                    help.executes(subcommand.friend.executor);
                    help.subcommands = new ArrayList<CommandBuilder>();
                    BrigadierCommand.register(help);
                }
            }
        }
        for (CommandBuilder subsubcommand : subcommand.subcommands) {
            BrigadierCommand.unPack(root.clone(), new ArrayList(arguments), subsubcommand);
        }
    }
}

