/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.core.commands;

import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.function.Function;
import java.util.function.Predicate;
import me.deecaad.core.commands.CommandData;
import me.deecaad.core.commands.Tooltip;
import me.deecaad.core.commands.arguments.CommandArgumentType;
import me.deecaad.core.compatibility.CompatibilityAPI;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.Style;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.permissions.Permission;

public class Argument<T> {
    private final String name;
    private final CommandArgumentType<T> type;
    private final T defaultValue;
    private final boolean isRequired;
    Function<CommandData, Tooltip[]> suggestions;
    Permission permission;
    Predicate<CommandSender> requirements;
    boolean isReplaceSuggestions;
    boolean listed;
    String description;

    public Argument(String name, CommandArgumentType<T> type) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("bad name");
        }
        this.name = name;
        this.type = type;
        this.defaultValue = null;
        this.isRequired = true;
        this.listed = true;
        this.description = "No description provided";
    }

    public Argument(String name, CommandArgumentType<T> type, T defaultValue) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("bad name");
        }
        this.name = name;
        this.type = type;
        this.defaultValue = defaultValue;
        this.isRequired = false;
        this.listed = true;
        this.description = "No description provided";
    }

    public String getName() {
        return this.name;
    }

    public CommandArgumentType<T> getType() {
        return this.type;
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    public boolean isRequired() {
        return this.isRequired;
    }

    public Argument<T> append(Function<CommandData, Tooltip[]> suggestions) {
        this.suggestions = suggestions;
        this.isReplaceSuggestions = false;
        return this;
    }

    public Argument<T> replace(Function<CommandData, Tooltip[]> suggestions) {
        this.suggestions = suggestions;
        this.isReplaceSuggestions = true;
        return this;
    }

    public Argument<T> withDesc(String description) {
        this.description = description;
        return this;
    }

    public Argument<T> withPermission(Permission permission) {
        this.permission = permission;
        if (permission != null && Bukkit.getPluginManager().getPermission(permission.getName()) == null) {
            Bukkit.getPluginManager().addPermission(permission);
        }
        return this;
    }

    public Argument<T> withRequirements(Predicate<CommandSender> requirements) {
        this.requirements = requirements;
        return this;
    }

    public boolean isListed() {
        return this.listed;
    }

    public Argument<T> setListed(boolean listed) {
        this.listed = listed;
        return this;
    }

    public T parse(CommandContext<Object> context, String key) throws CommandSyntaxException {
        return this.type.parse(context, key);
    }

    public Predicate<Object> requirements() {
        return nms -> {
            CommandSender sender = CompatibilityAPI.getCommandCompatibility().getCommandSenderRaw(nms);
            if (this.permission != null && !sender.hasPermission(this.permission)) {
                return false;
            }
            return this.requirements == null || this.requirements.test(sender);
        };
    }

    public String toString() {
        return this.name;
    }

    public TextComponent.Builder append(TextComponent.Builder builder, Style style) {
        if (this.isRequired()) {
            builder.append(Component.text().content(" <" + this.name).style(style));
            builder.append(((TextComponent.Builder)Component.text().content("*").color((TextColor)NamedTextColor.RED)).decorate(TextDecoration.ITALIC));
            builder.append(Component.text().content(">").style(style));
        } else {
            builder.append(Component.text().content(" <" + this.name + ">").style(style));
        }
        return builder;
    }
}

