/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.sagemakergeospatial;

import javax.annotation.Generated;

import com.amazonaws.services.sagemakergeospatial.model.*;

/**
 * Abstract implementation of {@code AmazonSageMakerGeospatialAsync}. Convenient method forms pass through to the
 * corresponding overload that takes a request object and an {@code AsyncHandler}, which throws an
 * {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAmazonSageMakerGeospatialAsync extends AbstractAmazonSageMakerGeospatial implements AmazonSageMakerGeospatialAsync {

    protected AbstractAmazonSageMakerGeospatialAsync() {
    }

    @Override
    public java.util.concurrent.Future<DeleteEarthObservationJobResult> deleteEarthObservationJobAsync(DeleteEarthObservationJobRequest request) {

        return deleteEarthObservationJobAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteEarthObservationJobResult> deleteEarthObservationJobAsync(DeleteEarthObservationJobRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteEarthObservationJobRequest, DeleteEarthObservationJobResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteVectorEnrichmentJobResult> deleteVectorEnrichmentJobAsync(DeleteVectorEnrichmentJobRequest request) {

        return deleteVectorEnrichmentJobAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteVectorEnrichmentJobResult> deleteVectorEnrichmentJobAsync(DeleteVectorEnrichmentJobRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteVectorEnrichmentJobRequest, DeleteVectorEnrichmentJobResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ExportEarthObservationJobResult> exportEarthObservationJobAsync(ExportEarthObservationJobRequest request) {

        return exportEarthObservationJobAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ExportEarthObservationJobResult> exportEarthObservationJobAsync(ExportEarthObservationJobRequest request,
            com.amazonaws.handlers.AsyncHandler<ExportEarthObservationJobRequest, ExportEarthObservationJobResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ExportVectorEnrichmentJobResult> exportVectorEnrichmentJobAsync(ExportVectorEnrichmentJobRequest request) {

        return exportVectorEnrichmentJobAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ExportVectorEnrichmentJobResult> exportVectorEnrichmentJobAsync(ExportVectorEnrichmentJobRequest request,
            com.amazonaws.handlers.AsyncHandler<ExportVectorEnrichmentJobRequest, ExportVectorEnrichmentJobResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetEarthObservationJobResult> getEarthObservationJobAsync(GetEarthObservationJobRequest request) {

        return getEarthObservationJobAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetEarthObservationJobResult> getEarthObservationJobAsync(GetEarthObservationJobRequest request,
            com.amazonaws.handlers.AsyncHandler<GetEarthObservationJobRequest, GetEarthObservationJobResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetRasterDataCollectionResult> getRasterDataCollectionAsync(GetRasterDataCollectionRequest request) {

        return getRasterDataCollectionAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetRasterDataCollectionResult> getRasterDataCollectionAsync(GetRasterDataCollectionRequest request,
            com.amazonaws.handlers.AsyncHandler<GetRasterDataCollectionRequest, GetRasterDataCollectionResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetTileResult> getTileAsync(GetTileRequest request) {

        return getTileAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetTileResult> getTileAsync(GetTileRequest request,
            com.amazonaws.handlers.AsyncHandler<GetTileRequest, GetTileResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetVectorEnrichmentJobResult> getVectorEnrichmentJobAsync(GetVectorEnrichmentJobRequest request) {

        return getVectorEnrichmentJobAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetVectorEnrichmentJobResult> getVectorEnrichmentJobAsync(GetVectorEnrichmentJobRequest request,
            com.amazonaws.handlers.AsyncHandler<GetVectorEnrichmentJobRequest, GetVectorEnrichmentJobResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListEarthObservationJobsResult> listEarthObservationJobsAsync(ListEarthObservationJobsRequest request) {

        return listEarthObservationJobsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListEarthObservationJobsResult> listEarthObservationJobsAsync(ListEarthObservationJobsRequest request,
            com.amazonaws.handlers.AsyncHandler<ListEarthObservationJobsRequest, ListEarthObservationJobsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListRasterDataCollectionsResult> listRasterDataCollectionsAsync(ListRasterDataCollectionsRequest request) {

        return listRasterDataCollectionsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListRasterDataCollectionsResult> listRasterDataCollectionsAsync(ListRasterDataCollectionsRequest request,
            com.amazonaws.handlers.AsyncHandler<ListRasterDataCollectionsRequest, ListRasterDataCollectionsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {

        return listTagsForResourceAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request,
            com.amazonaws.handlers.AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListVectorEnrichmentJobsResult> listVectorEnrichmentJobsAsync(ListVectorEnrichmentJobsRequest request) {

        return listVectorEnrichmentJobsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListVectorEnrichmentJobsResult> listVectorEnrichmentJobsAsync(ListVectorEnrichmentJobsRequest request,
            com.amazonaws.handlers.AsyncHandler<ListVectorEnrichmentJobsRequest, ListVectorEnrichmentJobsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<SearchRasterDataCollectionResult> searchRasterDataCollectionAsync(SearchRasterDataCollectionRequest request) {

        return searchRasterDataCollectionAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<SearchRasterDataCollectionResult> searchRasterDataCollectionAsync(SearchRasterDataCollectionRequest request,
            com.amazonaws.handlers.AsyncHandler<SearchRasterDataCollectionRequest, SearchRasterDataCollectionResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<StartEarthObservationJobResult> startEarthObservationJobAsync(StartEarthObservationJobRequest request) {

        return startEarthObservationJobAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<StartEarthObservationJobResult> startEarthObservationJobAsync(StartEarthObservationJobRequest request,
            com.amazonaws.handlers.AsyncHandler<StartEarthObservationJobRequest, StartEarthObservationJobResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<StartVectorEnrichmentJobResult> startVectorEnrichmentJobAsync(StartVectorEnrichmentJobRequest request) {

        return startVectorEnrichmentJobAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<StartVectorEnrichmentJobResult> startVectorEnrichmentJobAsync(StartVectorEnrichmentJobRequest request,
            com.amazonaws.handlers.AsyncHandler<StartVectorEnrichmentJobRequest, StartVectorEnrichmentJobResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<StopEarthObservationJobResult> stopEarthObservationJobAsync(StopEarthObservationJobRequest request) {

        return stopEarthObservationJobAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<StopEarthObservationJobResult> stopEarthObservationJobAsync(StopEarthObservationJobRequest request,
            com.amazonaws.handlers.AsyncHandler<StopEarthObservationJobRequest, StopEarthObservationJobResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<StopVectorEnrichmentJobResult> stopVectorEnrichmentJobAsync(StopVectorEnrichmentJobRequest request) {

        return stopVectorEnrichmentJobAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<StopVectorEnrichmentJobResult> stopVectorEnrichmentJobAsync(StopVectorEnrichmentJobRequest request,
            com.amazonaws.handlers.AsyncHandler<StopVectorEnrichmentJobRequest, StopVectorEnrichmentJobResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<TagResourceResult> tagResourceAsync(TagResourceRequest request) {

        return tagResourceAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<TagResourceResult> tagResourceAsync(TagResourceRequest request,
            com.amazonaws.handlers.AsyncHandler<TagResourceRequest, TagResourceResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request) {

        return untagResourceAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request,
            com.amazonaws.handlers.AsyncHandler<UntagResourceRequest, UntagResourceResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

}
