/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.resourceexplorer2.model;

import java.io.Serializable;
import javax.annotation.Generated;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/ListViews" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class ListViewsResult extends com.amazonaws.AmazonWebServiceResult<com.amazonaws.ResponseMetadata> implements Serializable, Cloneable {

    /**
     * <p>
     * If present, indicates that more output is available than is included in the current response. Use this value in
     * the <code>NextToken</code> request parameter in a subsequent call to the operation to get the next part of the
     * output. You should repeat this until the <code>NextToken</code> response element comes back as <code>null</code>.
     * The pagination tokens expire after 24 hours.
     * </p>
     */
    private String nextToken;
    /**
     * <p>
     * The list of views available in the Amazon Web Services Region in which you called this operation.
     * </p>
     */
    private java.util.List<String> views;

    /**
     * <p>
     * If present, indicates that more output is available than is included in the current response. Use this value in
     * the <code>NextToken</code> request parameter in a subsequent call to the operation to get the next part of the
     * output. You should repeat this until the <code>NextToken</code> response element comes back as <code>null</code>.
     * The pagination tokens expire after 24 hours.
     * </p>
     * 
     * @param nextToken
     *        If present, indicates that more output is available than is included in the current response. Use this
     *        value in the <code>NextToken</code> request parameter in a subsequent call to the operation to get the
     *        next part of the output. You should repeat this until the <code>NextToken</code> response element comes
     *        back as <code>null</code>. The pagination tokens expire after 24 hours.
     */

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    /**
     * <p>
     * If present, indicates that more output is available than is included in the current response. Use this value in
     * the <code>NextToken</code> request parameter in a subsequent call to the operation to get the next part of the
     * output. You should repeat this until the <code>NextToken</code> response element comes back as <code>null</code>.
     * The pagination tokens expire after 24 hours.
     * </p>
     * 
     * @return If present, indicates that more output is available than is included in the current response. Use this
     *         value in the <code>NextToken</code> request parameter in a subsequent call to the operation to get the
     *         next part of the output. You should repeat this until the <code>NextToken</code> response element comes
     *         back as <code>null</code>. The pagination tokens expire after 24 hours.
     */

    public String getNextToken() {
        return this.nextToken;
    }

    /**
     * <p>
     * If present, indicates that more output is available than is included in the current response. Use this value in
     * the <code>NextToken</code> request parameter in a subsequent call to the operation to get the next part of the
     * output. You should repeat this until the <code>NextToken</code> response element comes back as <code>null</code>.
     * The pagination tokens expire after 24 hours.
     * </p>
     * 
     * @param nextToken
     *        If present, indicates that more output is available than is included in the current response. Use this
     *        value in the <code>NextToken</code> request parameter in a subsequent call to the operation to get the
     *        next part of the output. You should repeat this until the <code>NextToken</code> response element comes
     *        back as <code>null</code>. The pagination tokens expire after 24 hours.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListViewsResult withNextToken(String nextToken) {
        setNextToken(nextToken);
        return this;
    }

    /**
     * <p>
     * The list of views available in the Amazon Web Services Region in which you called this operation.
     * </p>
     * 
     * @return The list of views available in the Amazon Web Services Region in which you called this operation.
     */

    public java.util.List<String> getViews() {
        return views;
    }

    /**
     * <p>
     * The list of views available in the Amazon Web Services Region in which you called this operation.
     * </p>
     * 
     * @param views
     *        The list of views available in the Amazon Web Services Region in which you called this operation.
     */

    public void setViews(java.util.Collection<String> views) {
        if (views == null) {
            this.views = null;
            return;
        }

        this.views = new java.util.ArrayList<String>(views);
    }

    /**
     * <p>
     * The list of views available in the Amazon Web Services Region in which you called this operation.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setViews(java.util.Collection)} or {@link #withViews(java.util.Collection)} if you want to override the
     * existing values.
     * </p>
     * 
     * @param views
     *        The list of views available in the Amazon Web Services Region in which you called this operation.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListViewsResult withViews(String... views) {
        if (this.views == null) {
            setViews(new java.util.ArrayList<String>(views.length));
        }
        for (String ele : views) {
            this.views.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * The list of views available in the Amazon Web Services Region in which you called this operation.
     * </p>
     * 
     * @param views
     *        The list of views available in the Amazon Web Services Region in which you called this operation.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListViewsResult withViews(java.util.Collection<String> views) {
        setViews(views);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getNextToken() != null)
            sb.append("NextToken: ").append(getNextToken()).append(",");
        if (getViews() != null)
            sb.append("Views: ").append(getViews());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof ListViewsResult == false)
            return false;
        ListViewsResult other = (ListViewsResult) obj;
        if (other.getNextToken() == null ^ this.getNextToken() == null)
            return false;
        if (other.getNextToken() != null && other.getNextToken().equals(this.getNextToken()) == false)
            return false;
        if (other.getViews() == null ^ this.getViews() == null)
            return false;
        if (other.getViews() != null && other.getViews().equals(this.getViews()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getNextToken() == null) ? 0 : getNextToken().hashCode());
        hashCode = prime * hashCode + ((getViews() == null) ? 0 : getViews().hashCode());
        return hashCode;
    }

    @Override
    public ListViewsResult clone() {
        try {
            return (ListViewsResult) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

}
