/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.opensearch.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * Information about the Amazon S3 Glue Data Catalog.
 * </p>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class S3GlueDataCatalog implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * &gt;The Amazon Resource Name (ARN) for the S3 Glue Data Catalog.
     * </p>
     */
    private String roleArn;

    /**
     * <p>
     * &gt;The Amazon Resource Name (ARN) for the S3 Glue Data Catalog.
     * </p>
     * 
     * @param roleArn
     *        &gt;The Amazon Resource Name (ARN) for the S3 Glue Data Catalog.
     */

    public void setRoleArn(String roleArn) {
        this.roleArn = roleArn;
    }

    /**
     * <p>
     * &gt;The Amazon Resource Name (ARN) for the S3 Glue Data Catalog.
     * </p>
     * 
     * @return &gt;The Amazon Resource Name (ARN) for the S3 Glue Data Catalog.
     */

    public String getRoleArn() {
        return this.roleArn;
    }

    /**
     * <p>
     * &gt;The Amazon Resource Name (ARN) for the S3 Glue Data Catalog.
     * </p>
     * 
     * @param roleArn
     *        &gt;The Amazon Resource Name (ARN) for the S3 Glue Data Catalog.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public S3GlueDataCatalog withRoleArn(String roleArn) {
        setRoleArn(roleArn);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getRoleArn() != null)
            sb.append("RoleArn: ").append(getRoleArn());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof S3GlueDataCatalog == false)
            return false;
        S3GlueDataCatalog other = (S3GlueDataCatalog) obj;
        if (other.getRoleArn() == null ^ this.getRoleArn() == null)
            return false;
        if (other.getRoleArn() != null && other.getRoleArn().equals(this.getRoleArn()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getRoleArn() == null) ? 0 : getRoleArn().hashCode());
        return hashCode;
    }

    @Override
    public S3GlueDataCatalog clone() {
        try {
            return (S3GlueDataCatalog) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.opensearch.model.transform.S3GlueDataCatalogMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
