/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.opensearch.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * Options for a domain's <a
 * href="https://docs.aws.amazon.com/opensearch-service/latest/APIReference/API_OffPeakWindow.html">off-peak window</a>,
 * during which OpenSearch Service can perform mandatory configuration changes on the domain.
 * </p>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class OffPeakWindowOptions implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * Whether to enable an off-peak window.
     * </p>
     * <p>
     * This option is only available when modifying a domain created prior to February 16, 2023, not when creating a new
     * domain. All domains created after this date have the off-peak window enabled by default. You can't disable the
     * off-peak window after it's enabled for a domain.
     * </p>
     */
    private Boolean enabled;
    /**
     * <p>
     * Off-peak window settings for the domain.
     * </p>
     */
    private OffPeakWindow offPeakWindow;

    /**
     * <p>
     * Whether to enable an off-peak window.
     * </p>
     * <p>
     * This option is only available when modifying a domain created prior to February 16, 2023, not when creating a new
     * domain. All domains created after this date have the off-peak window enabled by default. You can't disable the
     * off-peak window after it's enabled for a domain.
     * </p>
     * 
     * @param enabled
     *        Whether to enable an off-peak window.</p>
     *        <p>
     *        This option is only available when modifying a domain created prior to February 16, 2023, not when
     *        creating a new domain. All domains created after this date have the off-peak window enabled by default.
     *        You can't disable the off-peak window after it's enabled for a domain.
     */

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    /**
     * <p>
     * Whether to enable an off-peak window.
     * </p>
     * <p>
     * This option is only available when modifying a domain created prior to February 16, 2023, not when creating a new
     * domain. All domains created after this date have the off-peak window enabled by default. You can't disable the
     * off-peak window after it's enabled for a domain.
     * </p>
     * 
     * @return Whether to enable an off-peak window.</p>
     *         <p>
     *         This option is only available when modifying a domain created prior to February 16, 2023, not when
     *         creating a new domain. All domains created after this date have the off-peak window enabled by default.
     *         You can't disable the off-peak window after it's enabled for a domain.
     */

    public Boolean getEnabled() {
        return this.enabled;
    }

    /**
     * <p>
     * Whether to enable an off-peak window.
     * </p>
     * <p>
     * This option is only available when modifying a domain created prior to February 16, 2023, not when creating a new
     * domain. All domains created after this date have the off-peak window enabled by default. You can't disable the
     * off-peak window after it's enabled for a domain.
     * </p>
     * 
     * @param enabled
     *        Whether to enable an off-peak window.</p>
     *        <p>
     *        This option is only available when modifying a domain created prior to February 16, 2023, not when
     *        creating a new domain. All domains created after this date have the off-peak window enabled by default.
     *        You can't disable the off-peak window after it's enabled for a domain.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public OffPeakWindowOptions withEnabled(Boolean enabled) {
        setEnabled(enabled);
        return this;
    }

    /**
     * <p>
     * Whether to enable an off-peak window.
     * </p>
     * <p>
     * This option is only available when modifying a domain created prior to February 16, 2023, not when creating a new
     * domain. All domains created after this date have the off-peak window enabled by default. You can't disable the
     * off-peak window after it's enabled for a domain.
     * </p>
     * 
     * @return Whether to enable an off-peak window.</p>
     *         <p>
     *         This option is only available when modifying a domain created prior to February 16, 2023, not when
     *         creating a new domain. All domains created after this date have the off-peak window enabled by default.
     *         You can't disable the off-peak window after it's enabled for a domain.
     */

    public Boolean isEnabled() {
        return this.enabled;
    }

    /**
     * <p>
     * Off-peak window settings for the domain.
     * </p>
     * 
     * @param offPeakWindow
     *        Off-peak window settings for the domain.
     */

    public void setOffPeakWindow(OffPeakWindow offPeakWindow) {
        this.offPeakWindow = offPeakWindow;
    }

    /**
     * <p>
     * Off-peak window settings for the domain.
     * </p>
     * 
     * @return Off-peak window settings for the domain.
     */

    public OffPeakWindow getOffPeakWindow() {
        return this.offPeakWindow;
    }

    /**
     * <p>
     * Off-peak window settings for the domain.
     * </p>
     * 
     * @param offPeakWindow
     *        Off-peak window settings for the domain.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public OffPeakWindowOptions withOffPeakWindow(OffPeakWindow offPeakWindow) {
        setOffPeakWindow(offPeakWindow);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getEnabled() != null)
            sb.append("Enabled: ").append(getEnabled()).append(",");
        if (getOffPeakWindow() != null)
            sb.append("OffPeakWindow: ").append(getOffPeakWindow());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof OffPeakWindowOptions == false)
            return false;
        OffPeakWindowOptions other = (OffPeakWindowOptions) obj;
        if (other.getEnabled() == null ^ this.getEnabled() == null)
            return false;
        if (other.getEnabled() != null && other.getEnabled().equals(this.getEnabled()) == false)
            return false;
        if (other.getOffPeakWindow() == null ^ this.getOffPeakWindow() == null)
            return false;
        if (other.getOffPeakWindow() != null && other.getOffPeakWindow().equals(this.getOffPeakWindow()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getEnabled() == null) ? 0 : getEnabled().hashCode());
        hashCode = prime * hashCode + ((getOffPeakWindow() == null) ? 0 : getOffPeakWindow().hashCode());
        return hashCode;
    }

    @Override
    public OffPeakWindowOptions clone() {
        try {
            return (OffPeakWindowOptions) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.opensearch.model.transform.OffPeakWindowOptionsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
